/* mbed WatchDISP Library
 * Copyright (c) 2014 T.okamoto
 * Version 0.1 (19, September, 2014)
 * Released under the MIT License: http://mbed.org/license/mit
 */

#include "mbed.h"
//#define FRAME_SIZE 9328  //1flame = 212dot X 88dot  1dot = 4bit
#define FRAME_SIZE 27824  //1flame = 296dot X 188dot  1dot = 4bit

// RGBW color definitions   /*  R, G, B, W  */
#define Black           0x00    /*  0  0  0  0  */
#define Gray            0x01    /*  0  0  0  1  */
#define Blue            0x02    /*  0  0  1  0  */
#define LightBlue       0x03    /*  0  0  1  1  */
#define Green           0x04    /*  0  1  0  0  */
#define LightGreen      0x05    /*  0  1  0  1  */
#define Cyan            0x06    /*  0  1  1  0  */
#define LightCyan       0x07    /*  0  1  1  1  */
#define Red             0x08    /*  1  0  0  0  */
#define pink            0x09    /*  1  0  0  1  */
#define Magenta         0x0a    /*  1  0  1  0  */
#define LightMagenta    0x0b    /*  1  0  1  1  */
#define Yellow          0x0c    /*  1  1  0  0  */
#define LightYellow     0x0d    /*  1  1  0  1  */
#define LightGray       0x0e    /*  1  1  1  0  */
#define White           0x0f    /*  1  1  1  1  */

#define RGB8(r,g,b)   (((r & 0x80) >>4) | ((g & 0x80)>>5) | ((b & 0x80)>>6) ) & 0x0E  //6bit(8bit) MIP  MASK 0000 1110

class WatchDisp : public Stream {
public:
    WatchDisp(PinName mosi,PinName miso,PinName sclk,PinName cs); 
    void  writeDISP(void);
    void  clsBUF(void);
    void  locate(int x, int y);
    void foreground(uint8_t colour);
    void background(uint8_t colour);
    void command(char command);
    void setmarge(bool ifMarge);
    void set16col(char if16);
    void setWH(int width, int height);

    void character(int x, int y, int c);
    void pixel(int x, int y, uint8_t color);
    void LayerCopy(void);
    void circle(int x0, int y0, int r, uint8_t color);
    void fillcircle(int x0, int y0, int r, uint8_t color);
    void hline(int x0, int x1, int y, uint8_t color);
    void vline(int x, int y0, int y1, uint8_t color);
    void line(int x0, int y0, int x1, int y1, uint8_t color);
    void rect(int x0, int y0, int x1, int y1, uint8_t color);
    void fillrect(int x0, int y0, int x1, int y1, uint8_t color);
    void Symbol(unsigned int x, unsigned int y, unsigned char *symbol);
    void set_font(unsigned char* f);
    unsigned char* font;
   
//#define LCD_SPI    

protected:
    virtual int _putc(int value);
    virtual int _getc();
#ifdef LCD_SPI
    SPI        _spi;
#define  _spi_write _spi.write
#else
    DigitalOut _mosi;
    DigitalIn  _miso;
    DigitalOut _sclk;
    void _spi_write(uint8_t command);
#endif
    DigitalOut _cs;
    
    char _foreground;
    char _background;
    bool _ifMarge;
    char _if16;
        
    uint8_t _dispBUF[FRAME_SIZE];
    uint8_t _LayerBUF[FRAME_SIZE];
    int _height;
    int _width;
    unsigned int char_x;
    unsigned int char_y;
    
};
