#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 57600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX);

Timer TimeCount;

DigitalOut myled(LED1);

uint32_t Counter=0;

int main()
{
    pc.baud(57600);
    TimeCount.start();
    while(1) {
        wait_ms(20); // more or less 20 millis delay loop
        Counter++;
        Counter=Counter%50; // around 1hz frequency
        if (Counter==0) {
            myled = !myled;
        }
        pc.printf("REC:%d,%d\r\n",TimeCount.read_us(),Counter);
    }
}
