#include "mbed.h"

// Serial pc(SERIAL_TX, SERIAL_RX); // for debbug
 
// Peripherials
DigitalIn mybutton(USER_BUTTON);
DigitalOut myled(LED1);
AnalogIn AudioIn(A0);
AnalogOut AudioOut(A2);

// Define Ticker
Ticker Audio_Sample_Ticker;

// Audio Buffer
#define BUFFERSIZE 50000 // Sample rate 10 Khz, 5 sec record 50*10^3 samples
#define RECORD_US 100 // recording delay
#define PLAY_US 100  // play back delay
#define GAIN 2.0f
uint16_t ABuffer[BUFFERSIZE]={0};
// variables to store buffer position and lenght
int BufferEnd=0;
int Buffer_i=0;
bool RecordFull=0;
// Variable to store button state
bool ButtonState=0;
bool LastButtonState=0;

volatile bool Audio_Sample_Flag=0;

// Filter sound HPF to remove dc for amplification
// Simple First order filter
float AudioSignal=0;
float AHPF=0.99f; 

float LastY=0;
float CurY=0;
float LastU=0;
float CurU=0;

// Ticker function
void Audio_Sample() {
    Audio_Sample_Flag=1;;
}
 
int main() { // setup loop
  
  // attach Ticker object
  Audio_Sample_Ticker.attach_us(&Audio_Sample, RECORD_US); // create 10Khz Ticker
  
  while(1) { // infinite loop
    if (Audio_Sample_Flag){
        Audio_Sample_Flag=0;
        LastButtonState=ButtonState;
        ButtonState=mybutton.read();
        
            // Record sample and apply filter
            // Buffer variables
            LastU=CurU;
            CurU=AudioIn.read();
            LastY=CurY;
            
            // Simple Filter HPF
            CurY=AHPF*(LastY+CurU-LastU);
            
            // Amplify, add dc offset and add to buffer;
            AudioSignal=CurY*GAIN+0.5f;
            // trim signal
            if (AudioSignal>1){
                AudioSignal=1;
            }else if (AudioSignal<0){
                AudioSignal=0;
            }
        
        if ((!ButtonState)&&(!RecordFull) ){ // Button is pressed and record is not full
          myled.write(1); // LED On
          if (LastButtonState){ // first sample
              Buffer_i=0;
              // Re-set Ticker object
              Audio_Sample_Ticker.attach_us(&Audio_Sample, RECORD_US); // create 10Khz Ticker
          }
          // Record samples
           //ABuffer[Buffer_i]=AudioIn.read_u16();
            
            AudioSignal=AudioSignal*0xFFFF; // scale to 16 bit (aligned to left apparently, wasted an hour on that one)
            ABuffer[Buffer_i]=(uint16_t)AudioSignal; // Store to buffer;
            
            //pc.printf("%d \r\n",ABuffer[Buffer_i]); // debug check/
            //AudioOut.write_u16(ABuffer[Buffer_i]); // Debug output
            
          BufferEnd=Buffer_i;
          Buffer_i++;
          if (Buffer_i==BUFFERSIZE){ // buffer full
              RecordFull=1;
              Buffer_i=0; 
              myled.write(0); // LED Off // record off
          }
        
        }else if (ButtonState) { //Button is unpressed
          if (!LastButtonState){ // first sample
              // Re-set Ticker object
              Audio_Sample_Ticker.attach_us(&Audio_Sample, PLAY_US); // create 10Khz Ticker
              Buffer_i=BufferEnd;
          }
          myled.write(0); // LED Off
          // Play Recorded audio
          RecordFull=0;
           if (Buffer_i<=0){ // Replay record
              Buffer_i=BufferEnd;
           }
           AudioOut.write_u16(ABuffer[Buffer_i]);
           Buffer_i--;
        }
    }     
  }
}
 