//-----------------------------------------------NEW BP code starts--------------------------------///



#include "mbed.h"
#include "MAX30102.h" // BP ADD
#include <string.h>
#include <stdio.h>
#include "eeprom_pgm.h"
#include <time.h>
#include "ds3231.h"
#include "SDFileSystem.h"
#include "rtc.h"
#include "sdcard.h"
#include "ec_bp.h"
#include "bp.h"
#include "display_modules.h"
#include "main.h"


#define MAX_SBP_THRESHOLD 300
#define MAX_DBP_THRESHOLD 300
#define MIN_SBP_THRESHOLD 40
#define MIN_DBP_THRESHOLD 40

#define AVG_TYPE 8
#define SAMPLE_NO_ECG 1016
#define SAMPLE_NO_PPG 1656
 
FILE *fpecg_bp; // file pointer in place of fpecg- Suhasini- 21/7/17
FILE *fpppg1;

#include "struct.h"

void average_4_8(char file_name[],char file_name1[], uint32_t sampleno);


using namespace std;

Serial bpr(USBTX,USBRX);
DigitalIn INTR(PTC7);

Timer t; 


uint16_t ecgloc = 0;  // PPG and eCG maximum locations //int to uint16_t-Suhasini-21stJuly2017
uint16_t ppgloc = 0;  //int to uint16_t-Suhasini-21stJuly2017
uint16_t ebp = 0;      // variable for LOOP operation to read value from File i == ECG , j == PPG
uint16_t pbp = 0;  //int to uint16_t-Suhasini-21stJuly2017

void bp(uint32_t pid) {
    
    uint8_t uch_dummy;
    uint32_t ppgdata; 
    uint8_t lead_reg=0;
    uint32_t concatenate_value2 = 0;    //int to uint32_t-Suhasini-21stJuly2017
    uint8_t chk = 1;    //unsigned char to uint8_t-Suhasini-21stJuly2017
  char file_name[32]={0};
  char file_name1[32]={0};
  //uint8_t avg_type
  // uint32_t sampleno;
  
  
    //Declaration of  Master structure
    
    BLEMsg_info *ptr_BLEMsg_info_bp, BLEMsg_info_bp; // A copy of master strcuture [ "BLEMsg_info" ] by name "BLEMsg_info_bp" is created
    ptr_BLEMsg_info_bp = &BLEMsg_info_bp;            // *ptr_BLEMsg_info_bp is the pointer to local copy;
    
    // Declaration of Date Structure
    DateTime_info *ptr_DateTime_info_bp, DateTime_info_bp; // A copy of Master Structure "DateTime_info" created, 
    ptr_DateTime_info_bp = &DateTime_info_bp;             // Structure pointer points to that copy.
    
    
    // RTC operations
    time_t epoch_time_bp;           //A copy of time_t by name  epoch_time_bp is created 
    epoch_time_bp = rtc_read();    // time is got from get epoch function.  
    
    struct tm * ptr_time_info_bp, time_info_bp;   // Sturucture copy of tm is created
    ptr_time_info_bp = localtime(&epoch_time_bp); // Structure accepts the time in local format from "time_t" type.
      
    //BELOW LINE IS TO CHECK Date and TIME 
    bpr.printf("Time is %d: %d: %d\n", (*ptr_time_info_bp).tm_hour, (*ptr_time_info_bp).tm_min, (*ptr_time_info_bp).tm_sec);
    bpr.printf("Date is %d:%d:%d\n", (*ptr_time_info_bp).tm_mday, (*ptr_time_info_bp).tm_mon+1, (*ptr_time_info_bp).tm_year-100);
    
    //Copying from one structure to the other using variables
    DateTime_info_bp.hour = (uint8_t)(*ptr_time_info_bp).tm_hour;
    DateTime_info_bp.mins = (uint8_t)(*ptr_time_info_bp).tm_min;
    DateTime_info_bp.sec =  (uint8_t)(*ptr_time_info_bp).tm_sec;
    
    DateTime_info_bp.date = (uint8_t) (*ptr_time_info_bp).tm_mday;
    DateTime_info_bp.month =(uint8_t)(*ptr_time_info_bp).tm_mon+1;
    DateTime_info_bp.year = (uint8_t)(*ptr_time_info_bp).tm_year-100;
    
    // Copying Time to Main structure
    BLEMsg_info_bp.date_time.hour = DateTime_info_bp.hour;
    BLEMsg_info_bp.date_time.mins = DateTime_info_bp.mins;
    BLEMsg_info_bp.date_time.sec = DateTime_info_bp.sec;
    
    BLEMsg_info_bp.date_time.date = DateTime_info_bp.date ;
    BLEMsg_info_bp.date_time.month = DateTime_info_bp.month ;
    BLEMsg_info_bp.date_time.year =  DateTime_info_bp.year ;
    
    
    //Checking if the structure has these values    
    bpr.printf("Time 2 is %d:%d:%d\n", DateTime_info_bp.hour, DateTime_info_bp.mins, DateTime_info_bp.sec);
    bpr.printf("\t Date is %d:%d:%d\n",DateTime_info_bp.date, DateTime_info_bp.month, DateTime_info_bp.year);
    
    
    //Loading values to of Test type
    test_type_info test_type_info_bp;  // copy of " test_type_info" created  
    test_type_info_bp = BP_Test;       // Loaded value 00 to the test type 
    
    BLEMsg_info_bp.test_type = test_type_info_bp;
    //Check if 00 is getting printed
    bpr.printf("Test Type is : %d\n", test_type_info_bp);
    
    
    // Loading values of Length ,  PID, DID, sampling frequency, number of samples, calculated data.
    BLEMsg_info_bp.device_id = eprom_read_8(12);                   // Device ID fixed  // changed on 11/8/17 nikita
    BLEMsg_info_bp.patient_id = (uint32_t)pid;       // Patient ID
    BLEMsg_info_bp.sampling_freq = 500;              // sampling frrquency
    BLEMsg_info_bp.length = 10774;                   //Total length of data in bytes  22 B+10752 B
    
    BLEMsg_info_bp.num_samples.num_sample_ppg_dummy =  1664 ;// PPG  number of samples copied to master struct 
    BLEMsg_info_bp.num_samples.num_sample_ecg_OTtyp =  1024 ; // ECG  number of samples copied to master struct
    
    bpr.baud(baud_rate);

    freqset();               // setting the frequency
    setupfunc();              
    lead_reg=ecgsetupfunc();    // lead contact // 14/06
        
    maxim_max30102_reset();  // PPG reset
    wait_ms(20);
    maxim_max30102_init();
        
    chk = 1;
    wait(2);
    
    for(uint16_t i=0; i<500; i++)
    {
        concatenate_value2= readvalue();
        
        maxim_max30102_read_reg(0,&uch_dummy);
        while(INTR.read()==1); 
        maxim_max30102_read_fifo(&ppgdata); 
            
    }   
// BP Finger detect Function Added Nidhin 16/6/17 
// START    
 uint32_t un_max, un_min; // Declare two VARIABLE FOR MAX AND MIN
 un_max = 0;
un_min = 0x3FFF;
       
for(uint16_t i=0; i<500; i++)    // READS 500 SAMPLES TO SEE MAX AND MIN VAL DIFFERENCE
{        
maxim_max30102_read_reg(0,&uch_dummy);
while(INTR.read()==1); 
maxim_max30102_read_fifo(&ppgdata); 
bpr.printf("%d\n",ppgdata);
if(un_min>ppgdata)
un_min=ppgdata;    //update signal min
if(un_max<ppgdata)
un_max=ppgdata; 
}  

bpr.printf("The max is %d\n", un_max); //
bpr.printf("The min is %d\n", un_min);
if (((un_max -un_min) > 300) && (lead_reg==0)) // Checking for threshold 300 Added Nidhin 16/6/17

{ //Added Nidhin 16/6/17

    sd_open_BPfilee(pid);
    sd_open_BP_ECGfile(pid) ; //   sd_open_BP_ECGfile(123) draft file for testing
    sd_open_BP_PPGfile(pid) ; // sd_open_BP_PPGfile(123) draft file for testing

    FILE *ecg = NULL;
    FILE *ppg = NULL;
    
        for(uint16_t i=0; i<1024; i++)  //int to uint16_t-Suhasini-21stJuly2017
        {
            concatenate_value2 = readvalue();
            ecg = sd_BP_ecgwrite(&concatenate_value2);
            
            maxim_max30102_read_reg(0,&uch_dummy);
            while(INTR.read()==1); 
            maxim_max30102_read_fifo(&ppgdata); 
            ppg = sd_BP_ppgwrite(&ppgdata); //Change by Nidhin 30/5/2017 Direct writing to SD card.
         }
                
        for(uint16_t i=0; i<640; i++)   //int to uint16_t-Suhasini-21stJuly2017
        {
            maxim_max30102_read_reg(0,&uch_dummy);
            while(INTR.read()==1); 
            maxim_max30102_read_fifo(&ppgdata); 
            ppg = sd_BP_ppgwrite (&ppgdata);         //Change by Nidhin 30/5/2017 Direct writing to SD card.
        }
        
    fclose(ecg);
    fclose(ppg);
     
    maxim_max30102_reset();
    
///////////// Averaging on Raw Data ////////////////////////////
    
    sprintf(file_name,"/sd/%d_BP_ECG.csv",pid);
    sprintf(file_name1,"/sd/%d_BP_ECG_avg.csv",pid);
    
    average_4_8(file_name,file_name1,1024);
    
   // file_name[]={0};
   // file_name[]=(0};
    
    sprintf(file_name,"/sd/%d_BP_PPG.csv",pid);
    sprintf(file_name1,"/sd/%d_BP_PPG_avg.csv",pid);
    
    average_4_8(file_name,file_name1,1664);
    
    
    
    uint16_t eloc = 0;  //int to uint16_t-Suhasini-21stJuly2017
    uint16_t ploc = 0;  //int to uint16_t-Suhasini-21stJuly2017
   
   
   eloc = sd_BP_ECGMAX(pid); // eloc = sd_BP_ECGMAX(123);
   ploc = sd_BP_PPGMAX(pid); // ploc = sd_BP_PPGMAX(123);
   bpr.printf("eloc: %d ploc: %d\n",eloc,ploc);
   
   float PWV = 0;
   uint32_t d = 210000;     //int to uint32_t-Suhasini-21stJuly2017
   uint16_t delta_t = 0;    //int to uint16_t-Suhasini-21stJuly2017
   float SBP = 0;
   float DBP = 0;
   
   delta_t  = (2*(ploc - eloc));
   PWV = d/delta_t;
   
    SBP = 0.0508955*PWV+62.559;
    DBP = (0.0494*PWV + 17.480)+10;
    bpr.printf("sbp: %.0f dbp: %.0f\n",SBP,DBP);
    
    BLEMsg_info_bp.cal_data.cal_sbp_dummy = (uint16_t) SBP;
    BLEMsg_info_bp.cal_data.cal_dbp_OTtyp = (uint16_t) DBP;
    
     if((SBP > MAX_SBP_THRESHOLD || SBP < MIN_SBP_THRESHOLD)  && (DBP > MAX_DBP_THRESHOLD || DBP < MIN_SBP_THRESHOLD))              // checking for range below and above and then displaying error
     {
        screen_bp_error();             // checking for error out of range- nikita 10-7-17
        del_ppg_ecg_BPfile(pid);                          // Copy ECG and PPG data to BP file
        delete_subfiles(pid);     //added on 11/8/17 nikita
     } 
    
    else 
    { 
        create_single_BPfile(pid);                          // Copy ECG and PPG data to BP file
        structure_file(ptr_BLEMsg_info_bp, pid);            // Copy BP structure to main file
        bpfile_mainfile(pid);
        screen_bp1(SBP,DBP);
        if(get_filecreated_status() == false)                           //if file is in write mode 
        {   
            set_filecreated_status();                    
            increment_filepid (); 
        } 
    }
  }  //Added Nidhin 16/6/17  
  
  else  //Added Nidhin 16/6/17 
  {     //Added Nidhin 16/6/17 
    // Add display sequence for Finger detect fail  //Added Nidhin 16/6/17 
    maxim_max30102_reset();
    bpr.printf("no finger detect\n");
      screen_ecg_lead_bp_fingerdetect();
  }  //Added Nidhin 16/6/17 
     screen_ecg_bp() ; 
} 

////// AVERAGE FUNCTION///////////////////

void average_4_8( char file_name[],char file_name1[], uint32_t sampleno)
{
    
uint32_t ecg_raw[4];
uint32_t ecg_raw1[8];
uint32_t average=0;

uint16_t i;
FILE *fpecg =NULL;
FILE *fpecg_avg = NULL;


//sprintf(file_name,"/sd/%d_BP_ECG.csv",pid);
//sprintf(file_name1,"/sd/%d_BP_ECG_avg.csv",pid);

    fpecg = fopen(file_name,"r");
    
        if(fpecg == NULL)
        {
            printf("error in opening raw data file file");
            exit(1);
        }
    
    fpecg_avg= fopen(file_name1,"w");  //a
    
        if(fpecg_avg == NULL)
        {
            printf("error in opening average file");
            exit(1);
        }
     bpr.printf("open_avg_file\n");
    if (  AVG_TYPE == 4)
    {
        fread(ecg_raw,sizeof(uint32_t),3,fpecg);
        
        bpr.printf("four point average data are\n");
        for(i=0;i<(sampleno-4);i++)
        {
            fread(&ecg_raw[3], sizeof(uint32_t),1, fpecg);
            average = (ecg_raw[0] + ecg_raw[1] + ecg_raw[2] + ecg_raw[3])/4;
             fwrite(&average,sizeof(uint32_t),1,fpecg_avg);
             bpr.printf("%d\n",average);

            ecg_raw[0] = ecg_raw[1];
            ecg_raw[1] = ecg_raw[2];
            ecg_raw[2] = ecg_raw[3];    
        }
    }
    
    else
    {
        fread(ecg_raw1,sizeof(uint32_t),7,fpecg);
        bpr.printf("eight point average data are\n");
        
        for( i= 0 ;i<(sampleno-8);i++)
        {
            fread(&ecg_raw1[7], sizeof(uint32_t),1, fpecg);
            
            average = ( ecg_raw1[0] + ecg_raw1[1] + ecg_raw1[2] + ecg_raw1[3] + ecg_raw1[4] + ecg_raw1[5] + ecg_raw1[6] + ecg_raw1[7])/8;
            
            fwrite(&average,sizeof(uint32_t),1,fpecg_avg);
            bpr.printf("%d\n",average);
            
            ecg_raw1[0] = ecg_raw1[1];
            ecg_raw1[1] = ecg_raw1[2];
            ecg_raw1[2] = ecg_raw1[3];
            ecg_raw1[3] = ecg_raw1[4];
            ecg_raw1[4] = ecg_raw1[5];
            ecg_raw1[5] = ecg_raw1[6];
            ecg_raw1[6] = ecg_raw1[7];
            
        }
        
    }
    
    fclose(fpecg);
    fclose(fpecg_avg);
     bpr.printf("close_avg_file\n");
}


 //------------------------------------------  
 //REOPEN FUNCTIONs for reading data Nidhin
 
 uint16_t sd_BP_ECGMAX(int32_t pid)         
 {
  uint32_t ecgmax = 0;      // changed from int to uint32_t - suhasini - 21/7/17
  uint32_t a[1] = {0};      // changed from int to uint32_t - suhasini - 21/7/17
  uint16_t samplesecg =0;   // changed from int to uint32_t - suhasini - 21/7/17  
  char buffer1[32];
   
 // sprintf(buffer1,"/sd/%d_BP_ECG.csv",pid);
 sprintf(buffer1,"/sd/%d_BP_ECG_avg.csv",pid);
  fpecg_bp = fopen(buffer1,"r"); 
  if(fpecg_bp == NULL)
  {
            exit(1);
  }
  
  else
  {
    for(ebp=0; ebp<1016; ebp++)
    {

    
    fread(a,sizeof(uint32_t), 1,fpecg_bp);
        if(a[0] > ecgmax)
            {
                ecgmax=a[0];
                ecgloc= ebp +1;
            }
        else
        samplesecg =ebp+1;
    }
    }
   fclose (fpecg_bp);
   return ecgloc; 
 } 
 
 // Function to calculate PPG MAx and location
 
   uint16_t sd_BP_PPGMAX(int32_t pid)      //int to uint16_t-Suhasini-21stJuly2017
 {
  uint32_t ppgmax = 0;          //int to uint32_t-Suhasini-21stJuly2017
  uint32_t b[1] ={0};           //int to uint32_t-Suhasini-21stJuly2017
  uint16_t samplesppg = 0;      //int to uint16_t-Suhasini-21stJuly2017
  char buffer1[32];
   
 // sprintf(buffer1,"/sd/%d_BP_PPG.csv",pid);
 sprintf(buffer1,"/sd/%d_BP_PPG_avg.csv",pid);
  fpppg1 = fopen(buffer1,"r"); 
  if(fpppg1 == NULL)
  {
            exit(1);
  }
  
  else
  {
    for(pbp=0; pbp<1656 ; pbp++)
            {
                fread(b, sizeof(uint32_t),1, fpppg1);
                             
                if((pbp>ecgloc) && (pbp< (ecgloc+350)))
                    {
                        if(b[0] > ppgmax)
                            {
                                ppgmax=b[0];
                                ppgloc= pbp+1;
                            }
                        else
                            samplesppg =pbp+1;
                    }
                else 
                    samplesppg = pbp+1;
            }
    }        
    fclose (fpppg1);
    return ppgloc;
 } 