#include "mbed.h"
#include <Pulse1.h>

PulseInOut irda(PTD4);// en este puerto se pone el sensor infrarrojo
Serial pc(USBTX, USBRX);
DigitalOut led(LED1);
DigitalOut led2(LED2);
DigitalOut ledig(LED3);
DigitalOut ds(PTA5);
DigitalOut df(PTA4);


int header =0; //tiempo de cabecera pulso abajo
const int head_H = 2360*1.2; //+20% medida con osciloscopio en microsegundos
const int head_L = 2360*0.8;//-20%  medida con osciloscopio
int i=0;
const int T_alto=1200;//ponga su tiempo de la prueba
const int T_bajo=560;//ponga su tiempo de la prueba
const int num_bits = 12;//ponga su numero de bits
int num[num_bits];//cadena para almacenar todos los tiempos que conforman los bits de datos
int nbina[num_bits];
int chan=0;
int codig[12]= {0,0,1,0,0,0,0,0,1,1,1,0};
int dato; // tiempo de cada dato que se lee

int main()
{
    while(1) {
ini1:
        header=0;
        chan=0;
        led2=1;
        led=1;
        ledig=1;
        header = irda.read_low_us();    //funcion para leer un pulso de caida o bajo
        if (header > head_L && header < head_H) goto seguir;//verificar que este en la tolerancia +-20%
        else goto ini1;

seguir:
        //leo los datos de la trama y se meten a un arreglo
        wait_us(5000);
            for(i=0; i<=(num_bits-1); ++i) { // POR OSCILOSCOPIO se determina que llegan (num_bits),datos
            dato = irda.read_low_us(); //leer un bit de datos que es pulso arriba en este control
            num[i]=dato;
            wait_us(300);
        }
        wait(0.5); //espero un poquito antes de leer todo el arreglo y ponerlo en pantalla
        pc.printf(",%d",header);
        for(i=0; i<=(num_bits-1); ++i) {
            pc.printf(",%d",num[i]);
        }
        wait(0.1);  //espero e imprimo en binario
        pc.printf("\n\n");
        for(i=0; i<=(num_bits-1); ++i) {
            if(num[i] > ((T_alto+T_bajo)/2)) {
                nbina[i]=1;
                pc.printf("%d",nbina[i]);
            } else {
                nbina[i]=0;
                pc.printf("%d",nbina[i]);
            
            }
        }
        
        pc.printf("\n");
        for(i=0; i<=(num_bits-1); ++i) {
        pc.printf("%d",codig[i]);
        
        if(codig[i]==nbina[i]) {
            chan++;
        }
        }
            if(chan==12) {
            ds=1;df=0;
            wait(1);
            ds=0;df=0;led2=0;pc.printf("\nValvula On\n");
            wait(5);
            ds=0;df=1;
            wait(1);
            ds=0;df=0;ledig=0;led2=1;pc.printf("Valvula Off\n");
            wait(2);
            }

    }
}