#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"
#include "JPEGCamera.h"
//#include "rtos.h"


EthernetNetIf eth(
    IpAddr(172,16,20,20), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(172,16,20,1), //Gateway
    IpAddr(172,16,1,1)  
);
HTTPServer svr;

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
DigitalOut pin11(p11);      // pin for resetting
DigitalOut pin12(p12);      // pin for showing error with camera while taking reference image
DigitalOut pin13(p13);      // pin for showing error with camera while taking new image
DigitalOut pin1(p21);     
DigitalOut pin2(p22);     
DigitalOut pin3(p23);     // motor pin from analogVal of sensor 
DigitalOut pin4(p24);     // buzzer  
DigitalOut signalPin(p25);

Serial pc(USBTX,USBRX);
Serial xbee(p28, p27);    // TX, RX for Xbee
JPEGCamera camera(p9, p10); // TX, RX for Camera
LocalFileSystem fs("webfs");

//Create a function of the required format
void rpcX10rf(char * input, char * output);
RPCFunction rpc_foo(&rpcX10rf, "rpcX10rf");
void rpcX10rf(char * input, char * output) {
            char houseCode;
            short int numberCode, action;
            pc.printf("%s\r\n", input);
            sscanf(input, "  %c,%d,%d", &houseCode, &numberCode, &action);
            pc.printf("%c, %d,%d\r\n", houseCode, numberCode, action);
                 if(numberCode==1 && action==1){pin1=1;led2=1;}
            else if(numberCode==1 && action==0){pin1=0;led2=0;}
            else if(numberCode==2 && action==1){pin2=1;led3=1;}
            else if(numberCode==2 && action==0){pin2=0;led3=0;}
            else if(numberCode==3 && action==1){pin3=1;led4=1;}
            else {pin3=0;led4=0;}
            }

void callback() {
    // Note: read every byte from the serial to clear the RX interrupt
     char discard;
     if(xbee.getc()==0x7E)
     for(int i=1;i<19;i++) discard = xbee.getc();
     int high = xbee.getc();
     int low=xbee.getc();
     int analogVal= high*256 + low;
     pc.printf("High=%d Low=%d AnalogValue= %d\r\n",high,low,analogVal);
     while(xbee.readable()) discard=xbee.getc();  
     if(analogVal<300)
     pin3=1;     //  p25
     else pin3=0;
     
}
void doReset_ImgRef(void);
void takeNewImage(void);
void checkReset(void);
       
int main() 
{
      Timer tm;
      pc.baud(9600);
    xbee.baud(9600);
    xbee.attach(&callback);   
    signalPin=0;
    
    Base::add_rpc_class<DigitalOut>();
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        pc.printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    pc.printf("\r\nSetup OK\r\n");

    FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
    FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path

    //svr.addHandler<SimpleHandler>("/hello");
    svr.addHandler<RPCHandler>("/rpc");
    svr.addHandler<FSHandler>("/files");
    svr.addHandler<FSHandler>("/"); //Default handler
    //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm
    svr.bind(80);
    
    printf("Server Start and Setting Camera\r\n");
    
   // camera.reset();
  //  pc.printf("Setting SIZE 320X240");
    camera.setPictureSize(JPEGCamera::SIZE160x120);
  //  pc.printf("\nSetting SIZE 320X240 done and Taking reference image\n");

     doReset_ImgRef();

    tm.start();
  //  wt.start();
     while(pc.readable()==0)
{     Net::poll();
        if (tm.read()>.5) 
         { led1=!led1; //Show that we are alive
          tm.reset();
         }
      takeNewImage();
      checkReset();

}
}

void takeNewImage(void)
{   Timer wt;
    wt.start();
    if(signalPin==0)
    {      pc.printf("Capturing new image Picture\r\n");
     // camera.reset();
      if (camera.isReady()) 
       {    char filename[32];
            sprintf(filename, "/webfs/PICT.jpg");
            pc.printf("Picture: %s \r\n", filename);
            if (camera.takePicture(filename)) 
            { while (camera.isProcessing()) camera.processPicture();  
            } else {pc.printf("take picture failed\n"); led4=1;} // pin13=1;}
       }else {pc.printf("camera is not ready\n");led4=1;} // pin13=1;}
      led4=0; // pin13=0;
      pc.printf("Took PICT\r\n");
      signalPin=1;
    } else {pc.printf("waiting for processing \r\n");
            if (wt.read() > .5) {led3=!led3; wt.reset();} //Show that waiting for response
            
            }
}



void checkReset(void)
{
    if(pin11==1) {doReset_ImgRef();}
    if(pin12==1) checkReset();
    else pin11=0;
}



void doReset_ImgRef(void)
{
  camera.reset();
      if (camera.isReady()) 
    {
            char filename[32];
            sprintf(filename, "/webfs/IMG_REF.jpg");
            pc.printf("Picture: %s \r\n", filename);
            if (camera.takePicture(filename)) 
            {while (camera.isProcessing()) camera.processPicture();  
            } else {pc.printf("take picture failed\n"); pin12=1;}
    } else {pc.printf("camera is not ready\n"); pin12=1;}
    pin12=0;           
    pc.printf("Took IMG_REF \r\n");
  
}






