#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "RPCFunction.h"
EthernetNetIf eth(
    IpAddr(172,16,20,20), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(172,16,20,1), //Gateway
    IpAddr(172,16,1,1)  
);
HTTPServer svr;

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
DigitalOut pin1(p21);
DigitalOut pin2(p22);
DigitalOut pin3(p23);
DigitalOut pin4(p24);

LocalFileSystem fs("webfs");
//Create a function of the required format
void rpcX10rf(char * input, char * output);
RPCFunction rpc_foo(&rpcX10rf, "rpcX10rf");
void rpcX10rf(char * input, char * output) {
            char houseCode;
            short int numberCode, action;
            printf("%s\r\n", input);
            sscanf(input, "  %c,%d,%d", &houseCode, &numberCode, &action);
            printf("%c, %d,%d\r\n", houseCode, numberCode, action);
                 if(numberCode==1 && action==1){pin1=1;led2=1;}
            else if(numberCode==1 && action==0){pin1=0;led2=0;}
            else if(numberCode==2 && action==1){pin2=1;led3=1;}
            else if(numberCode==2 && action==0){pin2=0;led3=0;}
            else if(numberCode==3 && action==1){pin3=1;led4=1;}
            else {pin3=0;led4=0;}
            }
int main() {
    Base::add_rpc_class<DigitalOut>();
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("\r\nSetup OK\r\n");

    FSHandler::mount("/webfs", "/files"); //Mount /webfs path on /files web path
    FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path

    //svr.addHandler<SimpleHandler>("/hello");
    svr.addHandler<RPCHandler>("/rpc");
    svr.addHandler<FSHandler>("/files");
    svr.addHandler<FSHandler>("/"); //Default handler
    //Example : Access to mbed.htm : http://a.b.c.d/mbed.htm or http://a.b.c.d/files/mbed.htm
    svr.bind(80);

    printf("Listening...\n");

    Timer tm;
    tm.start();
    //Listen indefinitely
    while (1) {
        Net::poll();
        if (tm.read()>.5) {
            led1=!led1; //Show that we are alive
            tm.start();
        }
    }
}