#include "mbed.h"
#include "TextLCD.h"

struct UART_buf
{ 
    uint8_t STA;
    uint8_t MODE; 
    uint8_t CMD;
    uint8_t LEN;
    uint8_t DATA[32];
    uint8_t END; 
};
 
// rs, rw, e, d0-d3
TextLCD lcd(PB_12, PB_13, PB_14, PB_15, PA_9, PA_10, PA_11); 

Serial SerialUART(PA_2, PA_3);

volatile UART_buf RX_BUF;

void SerialUARTRX_ISR(void);

int main() {
    
    SerialUART.baud(115200);
    
    SerialUART.attach(&SerialUARTRX_ISR);

    while(1)
    {
    }
}

void SerialUARTRX_ISR(void)
{
    static uint8_t RX_count = 0, RX_Len = 32, RX_Status = 0;
    uint8_t rx_da = SerialUART.getc();
    char buf[32];
    switch(RX_Status)
    {
        case 0:
            if(rx_da == 0x76)
            {
                RX_BUF.STA = rx_da;
                RX_Status++;
            }
            break;
        case 1:
            RX_BUF.MODE = rx_da;
            RX_Status++;
            break;
        case 2:
            RX_BUF.CMD = rx_da;
            RX_Status++;
            break;
        case 3:
            RX_BUF.LEN = rx_da;
            RX_Len = RX_BUF.LEN;
            RX_Status++;
            if(RX_Len == 0)
                RX_Status++;
            break;
        case 4:
            RX_BUF.DATA[RX_count] = rx_da;
            RX_count++;
            if(RX_count == RX_Len)
            {
                RX_Status++;
                RX_count = 0;
                RX_Len = 32;
            }
            break;
        case 5:
            if(rx_da == 0x3E)
            {
                RX_BUF.END = rx_da;
                RX_Status = 0;
                switch(RX_BUF.MODE)
                {
                    case 0x01:
                        if(RX_BUF.CMD == 0x18)
                        {
                            lcd.locate(0, 0);
                            for(int i=0; i<32; i++)
                            {
                                if(i<RX_BUF.LEN)
                                    lcd.putc(RX_BUF.DATA[i]);
                                else
                                    lcd.putc(0x20);
                            }
                        }
                        break;
                }
            }
            break;
    }
}