#include "mbed.h"

struct UART_buf
{ 
    uint8_t STA;
    uint8_t MODE; 
    uint8_t CMD;
    uint8_t LEN;
    uint8_t DATA[32];
    uint8_t END; 
     
};
 
// LED1, LED2, LED3, LED4
PinName pin_LED[4] = {PB_12, PB_13, PB_14, PB_15};
// SW1, SW2, SW3, SW4
PinName pin_SW[4] = {PA_9, PA_10, PA_11, PA_12};

Serial SerialUART(PA_2, PA_3);

uint8_t Buffer[37];

BusOut Led(pin_LED[0], pin_LED[1], pin_LED[2], pin_LED[3]);
BusIn SW(pin_SW[0], pin_SW[1], pin_SW[2], pin_SW[3]);

UART_buf RX_BUF;

Ticker Sensor_Timer;
void SerialUARTRX_ISR(void);
void Timer_setting(uint8_t cmd, uint8_t value);
void Sensor_Read(void);

int main() {
    
    SerialUART.baud(115200);
    
    SerialUART.attach(&SerialUARTRX_ISR);
    
    Timer_setting(0x06, 1);
    
    while(1)
    {
    }
}

void SerialUARTRX_ISR(void)
{
    static uint8_t RX_count = 0, RX_Len = 32, RX_Status = 0;
    uint8_t rx_da = SerialUART.getc();
    switch(RX_Status)
    {
        case 0:
            if(rx_da == 0x76)
            {
                RX_BUF.STA = rx_da;
                RX_Status++;
            }
            break;
        case 1:
            RX_BUF.MODE = rx_da;
            RX_Status++;
            break;
        case 2:
            RX_BUF.CMD = rx_da;
            RX_Status++;
            break;
        case 3:
            RX_BUF.LEN = rx_da;
            RX_Len = RX_BUF.LEN;
            RX_Status++;
            if(RX_Len == 0)
                RX_Status++;
            break;
        case 4:
            RX_BUF.DATA[RX_count] = rx_da;
            RX_count++;
            if(RX_count == RX_Len)
            {
                RX_Status++;
                RX_count = 0;
                RX_Len = 32;
            }
            break;
        case 5:
            if(rx_da == 0x3E)
            {
                RX_BUF.END = rx_da;
                RX_Status = 0;
                switch(RX_BUF.MODE)
                {
                    case 0x01:
                        if(RX_BUF.CMD == 0x20)
                        {
                            Led = RX_BUF.DATA[0];
                        }
                        break;
                    case 0x04:
                        Timer_setting(RX_BUF.CMD, RX_BUF.DATA[0]);
                        break;
                }
            }
            break;
    }
}

void Timer_setting(uint8_t cmd, uint8_t value)
{
    double Time_value = 0;
    switch(cmd)
    {
        case 0x01:
            Time_value = 30;
            break;
        case 0x02:
            Time_value = 60;
            break;
        case 0x03:
            Time_value = 120;
            break;
        case 0x04:
            Time_value = 300;
            break;
        case 0x05:
            Time_value = 600;
            break;
        case 0x06:
            Time_value = value;
            Time_value = 1.0/Time_value;
            break;
    }
    Sensor_Timer.attach(&Sensor_Read, Time_value);
}

void Sensor_Read(void)
{
    Buffer[0] = 0x76;
    Buffer[1] = 0x01;
    Buffer[2] = 0x20;
    Buffer[3] = 0x01;
    Buffer[4] = (SW & 0x0F);
    Buffer[5] = 0x3E;
    for(int i=0; i<6; i++)
        SerialUART.putc(Buffer[i]);
}