#include "mbed.h"

struct UART_buf
{ 
    uint8_t STA;
    uint8_t MODE; 
    uint8_t CMD;
    uint8_t LEN;
    uint8_t DATA[32];
    uint8_t END; 
};
 
// 1A, 1B, 2A, 2B
PinName pin_STEP[4] = {PA_5, PA_6, PA_7, PA_8};

BusOut Step(pin_STEP[0], pin_STEP[1], pin_STEP[2], pin_STEP[3]);

uint8_t Phase_2[4] = {0x03, 0x06, 0x0C, 0x09};

Serial SerialUART(PA_2, PA_3);

UART_buf RX_BUF;

enum{STOP, CW, CCW};

void SerialUARTRX_ISR(void);

uint8_t Step_flag = STOP;

int main() {
    
    int step_count = 0;
    SerialUART.baud(115200);
    
    SerialUART.attach(&SerialUARTRX_ISR);
    
    while(1)
    {
        if(Step_flag == STOP)
        {
            Step = 0;
        }
        else if(Step_flag == CW)
        {
            Step = Phase_2[step_count++];
            
            if(step_count > 3)
            {
                step_count = 0;
            }
        }
        else
        {
            Step = Phase_2[step_count--];
            
            if(step_count < 0)
            {
                step_count = 3;
            }
        }
        wait(0.01);
    }
}

void SerialUARTRX_ISR(void)
{
    static uint8_t RX_count = 0, RX_Len = 32, RX_Status = 0;
    uint8_t rx_da = SerialUART.getc();
    switch(RX_Status)
    {
        case 0:
            if(rx_da == 0x76)
            {
                RX_BUF.STA = rx_da;
                RX_Status++;
            }
            break;
        case 1:
            RX_BUF.MODE = rx_da;
            RX_Status++;
            break;
        case 2:
            RX_BUF.CMD = rx_da;
            RX_Status++;
            break;
        case 3:
            RX_BUF.LEN = rx_da;
            RX_Len = RX_BUF.LEN;
            RX_Status++;
            if(RX_Len == 0)
                RX_Status++;
            break;
        case 4:
            RX_BUF.DATA[RX_count] = rx_da;
            RX_count++;
            if(RX_count == RX_Len)
            {
                RX_Status++;
                RX_count = 0;
                RX_Len = 32;
            }
            break;
        case 5:
            if(rx_da == 0x3E)
            {
                RX_BUF.END = rx_da;
                RX_Status = 0;
                switch(RX_BUF.MODE)
                {
                    case 0x01:
                        if(RX_BUF.CMD == 0x14)
                        {
                            Step_flag = RX_BUF.DATA[0];
                        }
                        break;
                }
            }
            break;
    }
}
