#include "mbed.h"

struct UART_buf
{ 
    uint8_t STA;
    uint8_t MODE; 
    uint8_t CMD;
    uint8_t LEN;
    uint8_t DATA[32];
    uint8_t END; 
};
 
PinName pin_SERVO = PA_5;

PwmOut Servo(pin_SERVO);

Serial SerialUART(PA_2, PA_3);

UART_buf RX_BUF;

uint8_t Servo_flag = 0, Servo_increase_flag = 1;

enum{STOP, CW, CCW};

void SerialUARTRX_ISR(void);
void Servo_angle(int16_t angle);

int main() {
    
    int Servo_value = 0;

    SerialUART.baud(115200);
    
    SerialUART.attach(&SerialUARTRX_ISR);
    
    Servo.period_ms(20);

    while(1)
    {
        if(Servo_flag)
        {
            Servo_angle(Servo_value);
            if(Servo_increase_flag)
            {
                Servo_value++;
                if(Servo_value >= 180)
                    Servo_increase_flag = 0;
            }
            else
            {
                Servo_value--;
                if(Servo_value <= 0)
                    Servo_increase_flag = 1;
            }
        }
        else
        {
            Servo = 0;
        }
        wait(0.012);
    }
}

void SerialUARTRX_ISR(void)
{
    static uint8_t RX_count = 0, RX_Len = 32, RX_Status = 0;
    uint8_t rx_da = SerialUART.getc();
    switch(RX_Status)
    {
        case 0:
            if(rx_da == 0x76)
            {
                RX_BUF.STA = rx_da;
                RX_Status++;
            }
            break;
        case 1:
            RX_BUF.MODE = rx_da;
            RX_Status++;
            break;
        case 2:
            RX_BUF.CMD = rx_da;
            RX_Status++;
            break;
        case 3:
            RX_BUF.LEN = rx_da;
            RX_Len = RX_BUF.LEN;
            RX_Status++;
            if(RX_Len == 0)
                RX_Status++;
            break;
        case 4:
            RX_BUF.DATA[RX_count] = rx_da;
            RX_count++;
            if(RX_count == RX_Len)
            {
                RX_Status++;
                RX_count = 0;
                RX_Len = 32;
            }
            break;
        case 5:
            if(rx_da == 0x3E)
            {
                RX_BUF.END = rx_da;
                RX_Status = 0;
                switch(RX_BUF.MODE)
                {
                    case 0x01:
                        if(RX_BUF.CMD == 0x13)
                        {
                            Servo_flag = RX_BUF.DATA[0];
                        }
                        break;
                }
            }
            break;
    }
}

void Servo_angle(int16_t angle)
{
    int16_t Angle = 600 + (angle * 10);
    Servo.pulsewidth_us(Angle);
}
