#include "mbed.h"

struct UART_buf
{ 
    uint8_t STA;
    uint8_t MODE; 
    uint8_t CMD;
    uint8_t LEN;
    uint8_t DATA[32];
    uint8_t END; 
};
 
PinName pin_LEDR = PB_6;
PinName pin_LEDG = PB_5;
PinName pin_LEDB = PB_4;

BusOut RGBled(pin_LEDR, pin_LEDG, pin_LEDB);

Serial SerialUART(PA_2, PA_3);

UART_buf RX_BUF;

void SerialUARTRX_ISR(void);

int main() {
    
    SerialUART.baud(115200);
    
    SerialUART.attach(&SerialUARTRX_ISR);
    
    RGBled = 0;
    
    while(1)
    {
    }
}

void SerialUARTRX_ISR(void)
{
    static uint8_t RX_count = 0, RX_Len = 32, RX_Status = 0;
    uint8_t rx_da = SerialUART.getc();
    switch(RX_Status)
    {
        case 0:
            if(rx_da == 0x76)
            {
                RX_BUF.STA = rx_da;
                RX_Status++;
            }
            break;
        case 1:
            RX_BUF.MODE = rx_da;
            RX_Status++;
            break;
        case 2:
            RX_BUF.CMD = rx_da;
            RX_Status++;
            break;
        case 3:
            RX_BUF.LEN = rx_da;
            RX_Len = RX_BUF.LEN;
            RX_Status++;
            if(RX_Len == 0)
                RX_Status++;
            break;
        case 4:
            RX_BUF.DATA[RX_count] = rx_da;
            RX_count++;
            if(RX_count == RX_Len)
            {
                RX_Status++;
                RX_count = 0;
                RX_Len = 32;
            }
            break;
        case 5:
            if(rx_da == 0x3E)
            {
                RX_BUF.END = rx_da;
                RX_Status = 0;
                switch(RX_BUF.MODE)
                {
                    case 0x01:
                        if(RX_BUF.CMD == 0x15)
                        {
                            RGBled = RX_BUF.DATA[0];
                        }
                        break;
                }
            }
            break;
    }
}

