#include "mbed.h"

struct UART_buf
{ 
    uint8_t STA;
    uint8_t MODE; 
    uint8_t CMD;
    uint8_t LEN;
    uint8_t DATA[32];
    uint8_t END; 
     
};
 
PinName pin_BUZZER = PD_2;
PinName pin_PIR = PB_2;

DigitalOut Buzzer(pin_BUZZER);
InterruptIn Pir(pin_PIR);

Serial SerialUART(PA_2, PA_3);

UART_buf RX_BUF;

uint8_t Buffer[37];

int pir_flag = 0;

void SerialUARTRX_ISR(void);
void PIR_ISR(void);
void Sensor_Read_Data(uint8_t data);

int main() {

    uint8_t PIR_check = 0;
    
    SerialUART.baud(115200);
    
    Pir.rise(&PIR_ISR);
    
    SerialUART.attach(&SerialUARTRX_ISR);
    
    Buzzer = 0;
    
    while(1)
    {
        if(pir_flag)
        {
            pir_flag = 0;
            if(PIR_check == 0)
            {
                Sensor_Read_Data(1);
                PIR_check = 1;
            }
            wait(1);
        }
        else if(PIR_check)
        {
            Sensor_Read_Data(0);
            PIR_check = 0;
            wait(1);
        }
    }
}

void PIR_ISR(void)
{
    pir_flag = 1;
}

void Sensor_Read_Data(uint8_t data)
{
    Buffer[0] = 0x76;
    Buffer[1] = 0x01;
    Buffer[2] = 0x10;
    Buffer[3] = 0x01;
    Buffer[4] = data;
    Buffer[5] = 0x3E;
    for(int i=0; i<6; i++)
        SerialUART.putc(Buffer[i]);
}

void SerialUARTRX_ISR(void)
{
    static uint8_t RX_count = 0, RX_Len = 32, RX_Status = 0;
    uint8_t rx_da = SerialUART.getc();
    switch(RX_Status)
    {
        case 0:
            if(rx_da == 0x76)
            {
                RX_BUF.STA = rx_da;
                RX_Status++;
            }
            break;
        case 1:
            RX_BUF.MODE = rx_da;
            RX_Status++;
            break;
        case 2:
            RX_BUF.CMD = rx_da;
            RX_Status++;
            break;
        case 3:
            RX_BUF.LEN = rx_da;
            RX_Len = RX_BUF.LEN;
            RX_Status++;
            if(RX_Len == 0)
                RX_Status++;
            break;
        case 4:
            RX_BUF.DATA[RX_count] = rx_da;
            RX_count++;
            if(RX_count == RX_Len)
            {
                RX_Status++;
                RX_count = 0;
                RX_Len = 32;
            }
            break;
        case 5:
            if(rx_da == 0x3E)
            {
                RX_BUF.END = rx_da;
                RX_Status = 0;
                switch(RX_BUF.MODE)
                {
                    case 0x01:
                        if(RX_BUF.CMD == 0x16)
                        {
                            Buzzer = RX_BUF.DATA[0];
                        }
                        break;
                }
            }
            break;
    }
}
