#include "mbed.h"

PinName pin_PIR = PB_2;

InterruptIn Pir(pin_PIR);

Serial SerialUART(PA_2, PA_3);

uint8_t Buffer[37];

int pir_flag = 0;

void PIR_ISR(void);
void Sensor_Read_Data(uint8_t data);

int main() {

    uint8_t PIR_check = 0;
    
    SerialUART.baud(115200);
    
    Pir.rise(&PIR_ISR);
    
    while(1)
    {
        if(pir_flag)
        {
            pir_flag = 0;
            if(PIR_check == 0)
            {
                Sensor_Read_Data(1);
                PIR_check = 1;
            }
            wait(1);
        }
        else if(PIR_check)
        {
            Sensor_Read_Data(0);
            PIR_check = 0;
            wait(1);
        }
    }
}

void PIR_ISR(void)
{
    pir_flag = 1;
}

void Sensor_Read_Data(uint8_t data)
{
    Buffer[0] = 0x76;
    Buffer[1] = 0x01;
    Buffer[2] = 0x10;
    Buffer[3] = 0x01;
    Buffer[4] = data;
    Buffer[5] = 0x3E;
    for(int i=0; i<6; i++)
        SerialUART.putc(Buffer[i]);
}