#include "mbed.h"

struct UART_buf
{ 
    uint8_t STA;
    uint8_t MODE; 
    uint8_t CMD;
    uint8_t LEN;
    uint8_t DATA[32];
    uint8_t END; 
     
};
 
// C1, C2, C3, C4
PinName pin_KEYPAD_C[4] = {PC_4, PC_5, PC_6, PC_7};
// R1, R2, R3, R4
PinName pin_KEYPAD_R[4] = {PC_8, PC_9, PC_10, PC_11};
    
DigitalInOut Keypad_C1(pin_KEYPAD_C[0]);
DigitalInOut Keypad_C2(pin_KEYPAD_C[1]);
DigitalInOut Keypad_C3(pin_KEYPAD_C[2]);
DigitalInOut Keypad_C4(pin_KEYPAD_C[3]);

// R1, R2, R3, R4
BusIn Keypad_R(pin_KEYPAD_R[0], pin_KEYPAD_R[1], pin_KEYPAD_R[2], pin_KEYPAD_R[3]);

char Key_value[16] = {'1', '2', '3', 'A', '4', '5', '6', 'B', '7', '8', '9', 'C', '*', '0', '#', 'D'}; 

Serial SerialUART(PA_2, PA_3);

uint8_t Buffer[37];

//UART_buf RX_BUF;

//Ticker Sensor_Timer;

//void SerialUARTRX_ISR(void);
//void Timer_setting(uint8_t cmd, uint8_t value);
//void Sensor_Read(void);
void Sensor_Read_Data(uint8_t data);
uint16_t Keypad_Read(void);

int main() {

    uint8_t Key_flag_pre = 0, i;
    uint16_t Keypad;
        
    SerialUART.baud(115200);
    
    //SerialUART.attach(&SerialUARTRX_ISR);
    
    //Timer_setting(0x06, 2);
    
    while(1)
    {
        Keypad = Keypad_Read();
        if(Keypad != 0)
        {
            for(i=0; i<16; i++)
            {
                if(Keypad & (0x0001 << i))
                {
                    if(Key_flag_pre != Key_value[i]);
                    {
                        Key_flag_pre = Key_value[i];
                        Sensor_Read_Data(Key_flag_pre);
                    }
                    break;
                }
            }
        }
        else
            Key_flag_pre = 0;
        wait(0.1);
    }
}

/*void SerialUARTRX_ISR(void)
{
    static uint8_t RX_count = 0, RX_Len = 32, RX_Status = 0;
    uint8_t rx_da = SerialUART.getc();
    switch(RX_Status)
    {
        case 0:
            if(rx_da == 0x76)
            {
                RX_BUF.STA = rx_da;
                RX_Status++;
            }
            break;
        case 1:
            RX_BUF.MODE = rx_da;
            RX_Status++;
            break;
        case 2:
            RX_BUF.CMD = rx_da;
            RX_Status++;
            break;
        case 3:
            RX_BUF.LEN = rx_da;
            RX_Len = RX_BUF.LEN;
            RX_Status++;
            if(RX_Len == 0)
                RX_Status++;
            break;
        case 4:
            RX_BUF.DATA[RX_count] = rx_da;
            RX_count++;
            if(RX_count == RX_Len)
            {
                RX_Status++;
                RX_count = 0;
                RX_Len = 32;
            }
            break;
        case 5:
            if(rx_da == 0x3E)
            {
                RX_BUF.END = rx_da;
                RX_Status = 0;
                switch(RX_BUF.MODE)
                {
                    case 0x04:
                        Timer_setting(RX_BUF.CMD, RX_BUF.DATA[0]);
                        break;
                }
            }
            break;
    }
}*/

/*void Timer_setting(uint8_t cmd, uint8_t value)
{
    double Time_value = 0;
    switch(cmd)
    {
        case 0x01:
            Time_value = 30;
            break;
        case 0x02:
            Time_value = 60;
            break;
        case 0x03:
            Time_value = 120;
            break;
        case 0x04:
            Time_value = 300;
            break;
        case 0x05:
            Time_value = 600;
            break;
        case 0x06:
            Time_value = value;
            Time_value = 1.0/Time_value;
            break;
    }
    Sensor_Timer.attach(&Sensor_Read, Time_value);
}*/
//
// bit   | 15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
// -------------------------------------------------------
// value |  D  #  0  *  C  9  8  7  B  6  5  4  A  3  2  1
//
//  1  2  3  A
//  4  5  6  B
//  7  8  9  C
//  *  0  #  D
//
uint16_t Keypad_Read(void)
{
    uint16_t keypad_tmp, Read_data = 0, i;
    for(i=0; i<4; i++)
    {
        switch(i)
        {
            case 0:
                Keypad_C1.output();
                Keypad_C1 = 1;
                break;
            case 1:
                Keypad_C2.output();
                Keypad_C2 = 1;
                break;
            case 2:
                Keypad_C3.output();
                Keypad_C3 = 1;
                break;
            case 3:
                Keypad_C4.output();
                Keypad_C4 = 1;
                break;
        }
        
        wait(0.001);
        keypad_tmp = Keypad_R;
        Read_data |= (keypad_tmp << (i*4));
        switch(i)
        {
            case 0:
                Keypad_C1 = 0;
                Keypad_C1.input();
                break;
            case 1:
                Keypad_C2 = 0;
                Keypad_C2.input();
                break;
            case 2:
                Keypad_C3 = 0;
                Keypad_C3.input();
                break;
            case 3:
                Keypad_C4 = 0;
                Keypad_C4.input();
                break;
        }
    }
    return Read_data;
}

void Sensor_Read_Data(uint8_t data)
{
    Buffer[0] = 0x76;
    Buffer[1] = 0x01;
    Buffer[2] = 0x19;
    Buffer[3] = 0x01;
    Buffer[4] = data;
    Buffer[5] = 0x3E;
    for(int i=0; i<6; i++)
        SerialUART.putc(Buffer[i]);
}
/*
void Sensor_Read(void)
{
    Buffer[0] = 0x76;
    Buffer[1] = 0x01;
    Buffer[2] = 0x05;
    Buffer[3] = 0x01;
    Buffer[4] = IR_Detect;
    Buffer[5] = 0x3E;
    for(int i=0; i<6; i++)
        SerialUART.putc(Buffer[i]);
}
*/