#include "mbed.h"

struct UART_buf
{ 
    uint8_t STA;
    uint8_t MODE; 
    uint8_t CMD;
    uint8_t LEN;
    uint8_t DATA[32];
    uint8_t END; 
     
};
 

#define DHTLIB_OK                0
#define DHTLIB_ERROR_CHECKSUM   -1
#define DHTLIB_ERROR_TIMEOUT    -2

PinName pin_DHT11 = PA_15;

Serial SerialUART(PA_2, PA_3);

uint8_t Buffer[37];

DigitalInOut data_pin(pin_DHT11);

UART_buf RX_BUF;

Timer tmr;
Timer tmr1;

int humi;
int temp;

void SerialUARTRX_ISR(void);
void Timer_setting(uint8_t cmd, uint8_t value);
void Sensor_Read(void);
int dht_read(void);

uint32_t T_period = 2000;
uint32_t timer_check = 0;

int main() {
    
    SerialUART.baud(115200);
    
    SerialUART.attach(&SerialUARTRX_ISR);
    
    //Timer_setting(0x06, 2);
    
    while(1)
    {
        if((timer_check + T_period) < tmr1.read_ms())
        {
            Sensor_Read();
            timer_check += T_period;
        }
    }
}

void SerialUARTRX_ISR(void)
{
    static uint8_t RX_count = 0, RX_Len = 32, RX_Status = 0;
    uint8_t rx_da = SerialUART.getc();
    switch(RX_Status)
    {
        case 0:
            if(rx_da == 0x76)
            {
                RX_BUF.STA = rx_da;
                RX_Status++;
            }
            break;
        case 1:
            RX_BUF.MODE = rx_da;
            RX_Status++;
            break;
        case 2:
            RX_BUF.CMD = rx_da;
            RX_Status++;
            break;
        case 3:
            RX_BUF.LEN = rx_da;
            RX_Len = RX_BUF.LEN;
            RX_Status++;
            if(RX_Len == 0)
                RX_Status++;
            break;
        case 4:
            RX_BUF.DATA[RX_count] = rx_da;
            RX_count++;
            if(RX_count == RX_Len)
            {
                RX_Status++;
                RX_count = 0;
                RX_Len = 32;
            }
            break;
        case 5:
            if(rx_da == 0x3E)
            {
                RX_BUF.END = rx_da;
                RX_Status = 0;
                switch(RX_BUF.MODE)
                {
                    case 0x04:
                        Timer_setting(RX_BUF.CMD, RX_BUF.DATA[0]);
                        break;
                }
            }
            break;
    }
}

void Timer_setting(uint8_t cmd, uint8_t value)
{
    double Time_value = 0;
    tmr1.stop();
    tmr1.reset();
    switch(cmd)
    {
        case 0x01:
            Time_value = 30;
            break;
        case 0x02:
            Time_value = 60;
            break;
        case 0x03:
            Time_value = 120;
            break;
        case 0x04:
            Time_value = 300;
            break;
        case 0x05:
            Time_value = 600;
            break;
        case 0x06:
            Time_value = value;
            Time_value = 1.0/Time_value;
            break;
    }
    tmr1.start();
    timer_check = tmr.read_ms();
    T_period = Time_value * 1000;
}

void Sensor_Read(void)
{
    Buffer[0] = 0x76;
    Buffer[1] = 0x01;
    Buffer[2] = 0x05;
    Buffer[3] = 0x02;
    if(dht_read() == 0)
    {
        Buffer[4] = temp;
        Buffer[5] = humi;
    }
    else
    {
        Buffer[4] = 0;
        Buffer[5] = 0;
    }
    Buffer[6] = 0x3E;
    for(int i=0; i<7; i++)
        SerialUART.putc(Buffer[i]);
}

int dht_read(void){
    
    // BUFFER TO RECEIVE
    uint8_t bits[5];
    uint8_t cnt = 7;
    uint8_t idx = 0;
    
    tmr.stop();
    tmr.reset();

    // EMPTY BUFFER
    for(int i=0; i< 5; i++) bits[i] = 0;

    // REQUEST SAMPLE
    data_pin.output();
    data_pin.write(0);
    wait_ms(18);
    data_pin.write(1);
    wait_us(10);
    data_pin.input();
    wait_us(40);

    // ACKNOWLEDGE or TIMEOUT
    unsigned long loopCnt = 10000;
    
    while(data_pin.read() == 0)if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;
 
    loopCnt = 10000;
    
    while(data_pin.read() == 1)if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

    // READ OUTPUT - 40 BITS => 5 BYTES or TIMEOUT

    for(int i=0; i<40; i++){
        
        loopCnt = 10000;
        
        while(data_pin.read() == 0)if(loopCnt-- == 0)return DHTLIB_ERROR_TIMEOUT;

        //unsigned long t = micros();
        //time_count = tmr.read_us();
        
        tmr.start();

        loopCnt = 10000;
        
        while(data_pin.read())if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

        if(tmr.read_us() > 40) bits[idx] |= (1 << cnt);
        
        tmr.stop();
        tmr.reset();
        
        if(cnt == 0){   // next byte?
        
            cnt = 7;    // restart at MSB
            idx++;      // next byte!
            
        }else cnt--;
        
    }

    // WRITE TO RIGHT VARS
    // as bits[1] and bits[3] are allways zero they are omitted in formulas.
    humi = bits[0]; 
    temp = bits[2]; 

    uint8_t sum = bits[0] + bits[1] + bits[2] + bits[3];
    
    if(bits[4] != sum){return DHTLIB_ERROR_CHECKSUM;}
    
    return DHTLIB_OK;
    
}