#include "mbed.h"

struct UART_buf
{ 
    uint8_t STA;
    uint8_t MODE; 
    uint8_t CMD;
    uint8_t LEN;
    uint8_t DATA[32];
    uint8_t END; 
};
 
// INA, INB
PinName pin_DC[2] = {PA_6, PA_7};

PwmOut INA(pin_DC[0]);
PwmOut INB(pin_DC[1]);

Serial SerialUART(PA_2, PA_3);

UART_buf RX_BUF;

enum{STOP, CW, CCW};

void SerialUARTRX_ISR(void);
void DC_Ctrl(uint8_t dir, float Speed);

int main() {
    
    SerialUART.baud(115200);
    
    SerialUART.attach(&SerialUARTRX_ISR);
    
    while(1)
    {
    }
}

void SerialUARTRX_ISR(void)
{
    static uint8_t RX_count = 0, RX_Len = 32, RX_Status = 0;
    uint8_t rx_da = SerialUART.getc();
    switch(RX_Status)
    {
        case 0:
            if(rx_da == 0x76)
            {
                RX_BUF.STA = rx_da;
                RX_Status++;
            }
            break;
        case 1:
            RX_BUF.MODE = rx_da;
            RX_Status++;
            break;
        case 2:
            RX_BUF.CMD = rx_da;
            RX_Status++;
            break;
        case 3:
            RX_BUF.LEN = rx_da;
            RX_Len = RX_BUF.LEN;
            RX_Status++;
            if(RX_Len == 0)
                RX_Status++;
            break;
        case 4:
            RX_BUF.DATA[RX_count] = rx_da;
            RX_count++;
            if(RX_count == RX_Len)
            {
                RX_Status++;
                RX_count = 0;
                RX_Len = 32;
            }
            break;
        case 5:
            if(rx_da == 0x3E)
            {
                RX_BUF.END = rx_da;
                RX_Status = 0;
                switch(RX_BUF.MODE)
                {
                    case 0x01:
                        if(RX_BUF.CMD == 0x12)
                        {
                            DC_Ctrl(RX_BUF.DATA[0], 50);
                        }
                        break;
                }
            }
            break;
    }
}

void DC_Ctrl(uint8_t dir, float Speed)
{
    switch(dir)
    {
        case STOP:
            INA = 0;
            INB = 0;
            break;
        case CW:
            INA = Speed/100;
            INB = 0;
            break;
        case CCW:
            INA = 0;
            INB = Speed/100;
            break;
    }
}
