#include "mbed.h"
#include "TextLCD.h"

PinName pin_CDS = PB_0;
PinName pin_LEDR = PB_6;
PinName pin_LEDG = PB_5;
PinName pin_LEDB = PB_4;

AnalogIn adc_CDS(pin_CDS);

// rs, rw, e, d0-d3
TextLCD lcd(PB_12, PB_13, PB_14, PB_15, PA_9, PA_10, PA_11); 

PwmOut LEDR(pin_LEDR);
PwmOut LEDG(pin_LEDG);
PwmOut LEDB(pin_LEDB);

float LED_Ctrl(int value);

int main() {

    int ADC_Data;
    float Brightness;
    LEDR = LED_Ctrl(0);
    LEDG = LED_Ctrl(0);
    LEDB = LED_Ctrl(0);

    lcd.printf(" ADC Data :     \n");
    lcd.printf(""); 
    while(1) {
        ADC_Data = adc_CDS.read()*4095;
        lcd.locate(12, 0);
        lcd.printf("%4d", ADC_Data);
        if(ADC_Data > 3000)
            ADC_Data = 3000;
        ADC_Data /= 30;
        Brightness = (100.0 - ADC_Data) / 100;
        LEDR = Brightness;
        LEDG = Brightness;
        LEDB = Brightness;
        wait(0.5);
    }
}

// brightness Control 0 ~ 100(%)
float LED_Ctrl(int value)
{
    float brightness = value;
    brightness /= 100;
    return brightness;
}