#include "mbed.h"
#include "TextLCD.h"

// C1, C2, C3, C4
PinName pin_KEYPAD_C[4] = {PC_4, PC_5, PC_6, PC_7};
// R1, R2, R3, R4
PinName pin_KEYPAD_R[4] = {PC_8, PC_9, PC_10, PC_11};
 // 1A, 1B, 2A, 2B
PinName pin_STEP[4] = {PA_5, PA_6, PA_7, PA_8};

PinName pin_BUZZER = PD_2;

DigitalOut Buzzer(pin_BUZZER);
  
DigitalInOut Keypad_C1(pin_KEYPAD_C[0]);
DigitalInOut Keypad_C2(pin_KEYPAD_C[1]);
DigitalInOut Keypad_C3(pin_KEYPAD_C[2]);
DigitalInOut Keypad_C4(pin_KEYPAD_C[3]);
BusOut Step(pin_STEP[0], pin_STEP[1], pin_STEP[2], pin_STEP[3]);

// R1, R2, R3, R4
BusIn Keypad_R(pin_KEYPAD_R[0], pin_KEYPAD_R[1], pin_KEYPAD_R[2], pin_KEYPAD_R[3]);
// rs, rw, e, d0-d3
TextLCD lcd(PB_12, PB_13, PB_14, PB_15, PA_9, PA_10, PA_11); 

enum{OPEN, CLOSE};

uint8_t Phase_2[4] = {0x03, 0x06, 0x0C, 0x09};
char Key_value[16] = {'1', '2', '3', 'A', '4', '5', '6', 'B', '7', '8', '9', 'C', '*', '0', '#', 'D'}; 
char Password[4] = {'0', '0', '0', '0'};
char NowPassword[4] = {'0', '0', '0', '0'};
volatile uint8_t Password_setting = 0, Password_check = 0, Doorlock_flag = 1;

volatile uint16_t Keypad = 0, Keypad_pre = 0, i;

uint16_t Keypad_Read(void);
void Doorlock(uint8_t mode);
void buzzer_ctrl(uint8_t count);
void key_save(char key);

int main() {
    
    char Key_Now_value;

    lcd.printf("Smart Doorlock\n");
    lcd.printf("Doorlock CLOSE");
        
    while(1) {
        Keypad = Keypad_Read();
        if(Keypad != 0)
        {
            if(Keypad_pre != Keypad)
            {
                Keypad_pre = Keypad;
                buzzer_ctrl(1);
                for(i=0; i<16; i++)
                {
                    if(Keypad & (0x0001 << i))
                    {
                        Key_Now_value = Key_value[i];
                        break;
                    }
                }
                if((Password_setting == 0) && (Password_check == 0))
                {
                    if(Key_Now_value == '*')
                    {
                        if(Doorlock_flag == 0)
                        {
                            Doorlock_flag = 1;
                            Doorlock(CLOSE);
                            buzzer_ctrl(2);
                            lcd.locate(0, 1);
                            lcd.printf("Doorlock CLOSE");
                        }
                        else
                        {
                            Password_check++;
                        }
                    }
                    else if(Key_Now_value == '#')
                    {
                        Password_setting++;
                    }
                }
                else
                {
                    if((Key_Now_value >= '0') && (Key_Now_value <= '9'))
                    {
                        key_save(Key_Now_value);
                        if(Password_setting)
                        {
                            Password_setting++;
                        }
                        else if(Password_check)
                        {
                            Password_check++;
                        }
                    }
                    else if(Password_setting)
                    {
                        if(Key_Now_value == '#')
                        {
                            if(Password_setting >= 5)
                            {
                                for(i=0; i<4; i++)
                                    Password[i] = NowPassword[i];
                                buzzer_ctrl(3);
                            }
                            Password_setting = 0;
                        }
                    }
                    else if(Password_check)
                    {
                        if(Key_Now_value == '*')
                        {
                            if(Password_check >= 5)
                            {
                                Password_check = 0;
                                for(i=0; i<4; i++)
                                {
                                    if(Password[i] != NowPassword[i])
                                    {
                                        Password_check++;
                                    }
                                }
                                if(Password_check == 0)
                                {
                                    Doorlock(OPEN);
                                    lcd.locate(0, 1);
                                    lcd.printf("Doorlock OPEN ");
                                    buzzer_ctrl(3);
                                    Doorlock_flag = 0;
                                }
                                else
                                {
                                    lcd.locate(0, 1);
                                    lcd.printf("Password Error");
                                    buzzer_ctrl(2);
                                    wait(2);
                                    lcd.locate(0, 1);
                                    lcd.printf("Doorlock CLOSE");
                                }
                            }
                            Password_check = 0;
                        }
                    }
                }
            }
        }
        else
        {
            Keypad_pre = 0;
        }
    }
}

//
// bit   | 15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
// -------------------------------------------------------
// value |  D  #  0  *  C  9  8  7  B  6  5  4  A  3  2  1
//
//  1  2  3  A
//  4  5  6  B
//  7  8  9  C
//  *  0  #  D
//
uint16_t Keypad_Read(void)
{
    uint16_t keypad_tmp, Read_data = 0, i;
    for(i=0; i<4; i++)
    {
        switch(i)
        {
            case 0:
                Keypad_C1.output();
                Keypad_C1 = 1;
                break;
            case 1:
                Keypad_C2.output();
                Keypad_C2 = 1;
                break;
            case 2:
                Keypad_C3.output();
                Keypad_C3 = 1;
                break;
            case 3:
                Keypad_C4.output();
                Keypad_C4 = 1;
                break;
        }
        
        wait(0.001);
        keypad_tmp = Keypad_R;
        Read_data |= (keypad_tmp << (i*4));
        switch(i)
        {
            case 0:
                Keypad_C1 = 0;
                Keypad_C1.input();
                break;
            case 1:
                Keypad_C2 = 0;
                Keypad_C2.input();
                break;
            case 2:
                Keypad_C3 = 0;
                Keypad_C3.input();
                break;
            case 3:
                Keypad_C4 = 0;
                Keypad_C4.input();
                break;
        }
    }
    return Read_data;
}

void Doorlock(uint8_t mode)
{
    int16_t i;
    
    if(mode == OPEN)
    {
        for(i=0; i<200; i++)
        {
            Step = Phase_2[i%4];
            wait(0.005);
        }
    }
    else
    {
        for(i=200; i>=0; i--)
        {
            Step = Phase_2[i%4];
            wait(0.005);
        }
    }
}

void buzzer_ctrl(uint8_t count)
{
    int i;
    for(i=0; i<count; i++)
    {
        Buzzer = 1;
        wait(0.1);
        Buzzer = 0;
        if(i != (count-1))
            wait(0.1);
    }
}

void key_save(char key)
{
    int i;
    for(i=0; i<3; i++)
    {
        NowPassword[i] = NowPassword[i+1];
    }
    NowPassword[3] = key;
}