#include "mbed.h"
#include "TextLCD.h"

#define DHTLIB_OK                0
#define DHTLIB_ERROR_CHECKSUM   -1
#define DHTLIB_ERROR_TIMEOUT    -2

PinName pin_DHT11 = PA_15;

// INA, INB
PinName pin_DC[2] = {PA_6, PA_7};

DigitalInOut data_pin(pin_DHT11);
PwmOut INA(pin_DC[0]);
PwmOut INB(pin_DC[1]);

// rs, rw, e, d0-d3
TextLCD lcd(PB_12, PB_13, PB_14, PB_15, PA_9, PA_10, PA_11); 

enum{STOP, CW, CCW};

uint8_t Temp_High = 28, Temp_Low = 26, Aircon_flag = 0;

Timer tmr;

int humi;
int temp;

void DC_Ctrl(uint8_t dir, float Speed);
int dht_read(void);

int main() {
    
    lcd.printf("Temp :    [C]\n");
    lcd.printf("DC MOTOR : OFF");
    
    while(1) {
        if(dht_read() == 0)
        {
            lcd.locate(7, 0);
            lcd.printf("%3d", temp);
            if(Aircon_flag == 0)
            {
                if(Temp_High <= temp)
                {
                    DC_Ctrl(CW, 50);
                    lcd.locate(11, 1);
                    lcd.printf("ON ");
                    Aircon_flag = 1;
                }
            }
            else
            {
                if(Temp_Low >= temp)
                {
                    DC_Ctrl(STOP, 0);
                    lcd.locate(11, 1);
                    lcd.printf("OFF");
                    Aircon_flag = 0;
                }
            }
        }
        wait(2);
    }
}

void DC_Ctrl(uint8_t dir, float Speed)
{
    switch(dir)
    {
        case STOP:
            INA = 0;
            INB = 0;
            break;
        case CW:
            INA = Speed/100;
            INB = 0;
            break;
        case CCW:
            INA = 0;
            INB = Speed/100;
            break;
    }
}

int dht_read(void){
    
    // BUFFER TO RECEIVE
    uint8_t bits[5];
    uint8_t cnt = 7;
    uint8_t idx = 0;
    
    tmr.stop();
    tmr.reset();

    // EMPTY BUFFER
    for(int i=0; i< 5; i++) bits[i] = 0;

    // REQUEST SAMPLE
    data_pin.output();
    data_pin.write(0);
    wait_ms(18);
    data_pin.write(1);
    wait_us(10);
    data_pin.input();
    wait_us(40);

    // ACKNOWLEDGE or TIMEOUT
    unsigned long loopCnt = 10000;
    
    while(data_pin.read() == 0)if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;
 
    loopCnt = 10000;
    
    while(data_pin.read() == 1)if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

    // READ OUTPUT - 40 BITS => 5 BYTES or TIMEOUT

    for(int i=0; i<40; i++){
        
        loopCnt = 10000;
        
        while(data_pin.read() == 0)if(loopCnt-- == 0)return DHTLIB_ERROR_TIMEOUT;

        //unsigned long t = micros();
        tmr.start();

        loopCnt = 10000;
        
        while(data_pin.read())if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

        if(tmr.read_us() > 40) bits[idx] |= (1 << cnt);
        
        tmr.stop();
        tmr.reset();
        
        if(cnt == 0){   // next byte?
        
            cnt = 7;    // restart at MSB
            idx++;      // next byte!
            
        }else cnt--;
        
    }

    // WRITE TO RIGHT VARS
    // as bits[1] and bits[3] are allways zero they are omitted in formulas.
    humi = bits[0]; 
    temp = bits[2]; 

    uint8_t sum = bits[0] + bits[1] + bits[2] + bits[3];
    
    if(bits[4] != sum){return DHTLIB_ERROR_CHECKSUM;}
    
    return DHTLIB_OK;
    
}