#include "mbed.h"

PinName pin_LEDR = PB_6;
PinName pin_LEDG = PB_5;
PinName pin_LEDB = PB_4;

PwmOut LEDR(pin_LEDR);
PwmOut LEDG(pin_LEDG);
PwmOut LEDB(pin_LEDB);

float LED_Ctrl(int value);

int main() {
    // RGB LED OFF
    LEDR = LED_Ctrl(0);
    LEDG = LED_Ctrl(0);
    LEDB = LED_Ctrl(0);
    
    while(1) {

        // Red Led Control Increase brightness
        for(int i=0; i<=100; i++)
        {
            LEDR = LED_Ctrl(i);
            wait(0.025);
        }
        // Red LED Off
        LEDR = LED_Ctrl(0);
        // Green Led Control Increase brightness
        for(int i=0; i<=100; i++)
        {
            LEDG= LED_Ctrl(i);
            wait(0.025);
        }
        // Green LED Off
        LEDG = LED_Ctrl(0);
        // Blue Led Control Increase brightness
        for(int i=0; i<=100; i++)
        {
            LEDB = LED_Ctrl(i);
            wait(0.025);
        }
        // Blue LED Off
        LEDB = LED_Ctrl(0);
    }
}

// brightness Control 0 ~ 100(%)
float LED_Ctrl(int value)
{
    float brightness = value;
    brightness /= 100;
    return brightness;
}