#include "mbed.h"
#include "TextLCD.h"

PinName pin_PSD = PC_1;

AnalogIn adc_PSD(pin_PSD);

// rs, rw, e, d0-d3
TextLCD lcd(PB_12, PB_13, PB_14, PB_15, PA_9, PA_10, PA_11); 

uint8_t Dist_cm(float volt);

int main() {

    uint8_t dist;
    lcd.printf("  PSD  Program\n");
    lcd.printf(" Dist :     [cm]"); 
    while(1) {
        dist = Dist_cm(adc_PSD.read() * 3.3);
        lcd.locate(10, 1);
        lcd.printf("%2d", dist);
        wait(0.5);
    }
}

uint8_t Dist_cm(float volt)
{
//    float dist = 1.0/(0.0875 * volt - 0.00658);
    uint8_t result = 0;
    float dist = 1.0/(0.093 * volt - 0.009);
    if(dist < 0)
        result = 30;
    else
        result = dist;
    
    if(result < 4)
        result = 4;
    else if(result > 30)
        result = 30;
    return result;
}