#include "mbed.h"

// C1, C2, C3, C4
PinName pin_KEYPAD_C[4] = {PC_4, PC_5, PC_6, PC_7};
// R1, R2, R3, R4
PinName pin_KEYPAD_R[4] = {PC_8, PC_9, PC_10, PC_11};
    
DigitalInOut Keypad_C1(pin_KEYPAD_C[0]);
DigitalInOut Keypad_C2(pin_KEYPAD_C[1]);
DigitalInOut Keypad_C3(pin_KEYPAD_C[2]);
DigitalInOut Keypad_C4(pin_KEYPAD_C[3]);

char Key_value[16] = {'1', '2', '3', 'A', '4', '5', '6', 'B', '7', '8', '9', 'C', '*', '0', '#', 'D'}; 

// R1, R2, R3, R4
BusIn Keypad_R(pin_KEYPAD_R[0], pin_KEYPAD_R[1], pin_KEYPAD_R[2], pin_KEYPAD_R[3]);

Serial SerialUART(PA_2, PA_3);

uint16_t Keypad_Read(void);

int main() {
    uint16_t Keypad = 0, i;
    SerialUART.baud(115200);
    SerialUART.printf("\n\r Key pad Push");
    
    while(1) {
        Keypad = Keypad_Read();
        if(Keypad != 0)
        {
            SerialUART.printf("\n\r KeyPad : ");
            for(i=0; i<16; i++)
            {
                if(Keypad & (0x0001 << i))
                {
                    SerialUART.printf(" %c Pushed",Key_value[i]);
                    break;
                }
            }
            wait(0.5);
        }
    }
}

//
// bit   | 15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
// -------------------------------------------------------
// value |  D  #  0  *  C  9  8  7  B  6  5  4  A  3  2  1
//
//  1  2  3  A
//  4  5  6  B
//  7  8  9  C
//  *  0  #  D
//
uint16_t Keypad_Read(void)
{
    uint16_t keypad_tmp, Read_data = 0, i;
    for(i=0; i<4; i++)
    {
        switch(i)
        {
            case 0:
                Keypad_C1.output();
                Keypad_C1 = 1;
                break;
            case 1:
                Keypad_C2.output();
                Keypad_C2 = 1;
                break;
            case 2:
                Keypad_C3.output();
                Keypad_C3 = 1;
                break;
            case 3:
                Keypad_C4.output();
                Keypad_C4 = 1;
                break;
        }
        
        wait(0.001);
        keypad_tmp = Keypad_R;
        Read_data |= (keypad_tmp << (i*4));
        switch(i)
        {
            case 0:
                Keypad_C1 = 0;
                Keypad_C1.input();
                break;
            case 1:
                Keypad_C2 = 0;
                Keypad_C2.input();
                break;
            case 2:
                Keypad_C3 = 0;
                Keypad_C3.input();
                break;
            case 3:
                Keypad_C4 = 0;
                Keypad_C4.input();
                break;
        }
    }
    return Read_data;
}