#include "mbed.h"

PinName pin_BUZZER = PD_2;
PinName pin_PIR = PB_2;

// I2C address
int DoT_ADDR = 0x71<<1;

DigitalOut Buzzer(pin_BUZZER);
InterruptIn Pir(pin_PIR);
I2C Dotmatrix(I2C_SDA, I2C_SCL);

//char Data_BUF[17] = {0, 0x28, 0, 0x28, 0, 0xBA, 0, 0xBA, 0, 0x7C, 0, 0x10, 0, 0x38, 0, 0x38, 0};
char Data_BUF[17] = {0, 0x14, 0, 0x14, 0, 0x5D, 0, 0x5D, 0, 0x3E, 0, 0x08, 0, 0x1C, 0, 0x1C, 0};
char Clear_BUF[17] = {0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile int pir_flag = 0, Intruder_flag = 0, Blink_flag = 0;

void PIR_ISR(void);
void data_write(char *data, int len);
void Command_Write(uint8_t com);
void Dotmatrix_init(void);

int main()
{
    Dotmatrix_init();
    data_write(Clear_BUF, 17);
    
    Pir.rise(&PIR_ISR);
    Buzzer = 0;
    
    while(1){
        if(pir_flag == 1)
        {
            Intruder_flag = 1;
            pir_flag = 0;
        }
        else
        {
            Intruder_flag = 0;
        }
        if((Intruder_flag == 1) && (Blink_flag ==0))
        {
            Blink_flag = 1;
            data_write(Data_BUF, 17);
            Buzzer = 1;
        }
        else
        {
            Blink_flag = 0;
            data_write(Clear_BUF, 17);
            Buzzer = 0;
        }
        wait(0.5);
    }
}

void PIR_ISR(void)
{
    pir_flag = 1;
}

void data_write(char *data, int len)
{
    data[0] = 0;
    Dotmatrix.write(DoT_ADDR, data, len);
}

void Command_Write(char com)
{
    Dotmatrix.write(DoT_ADDR, &com, 1);
}

void Dotmatrix_init(void)
{
    // Internal System Clock enable
    Command_Write((char)0x21);
    // INT/ROW output pin Set -> ROW Driver output
    Command_Write((char)0xA0);
    // Dimming Set -> 15
    Command_Write((char)0xEF);
    // Blinking Set -> off
    // Display Set -> on
    Command_Write((char)0x81);
}
