#include "mbed.h"
#include "TextLCD.h"

PinName pin_FLAME_A = PA_0;
PinName pin_FLAME_D = PB_1;

AnalogIn adc_Flame(pin_FLAME_A);
DigitalIn Flame(pin_FLAME_D);

// rs, rw, e, d0-d3
TextLCD lcd(PB_12, PB_13, PB_14, PB_15, PA_9, PA_10, PA_11); 

int main() {
    
    int volt, flame_d;
    lcd.printf(" Volt :     [mV]"); 
    lcd.locate(0, 1);
    lcd.printf("Flame Status : "); 
    while(1) {
        volt = adc_Flame.read()*3300;
        flame_d = !Flame;
        lcd.locate(8, 0);
        lcd.printf("%4d", volt);
        lcd.locate(15, 1);
        lcd.printf("%d", flame_d);
        wait(1);
    }
}
