#include "mbed.h"
#include "font_5x7.h"

// I2C address
int DoT_ADDR = 0x71<<1;

I2C Dotmatrix(I2C_SDA, I2C_SCL);

char Data_BUF[17] = {0, 0 ,0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

void data_write(char *data, int len);
void Command_Write(uint8_t com);
void Dotmatrix_init(void);
void char_data_write(char data);

int main()
{
    uint8_t C_Data = 0x21;
    Dotmatrix_init();
    //data_write(Data_BUF, 17);
    
    while(1){
        char_data_write(C_Data++);
        if(C_Data == 0x80)
            C_Data = 0x21;
        wait(0.8);
    }
}

void data_write(char *data, int len)
{
    data[0] = 0;
    Dotmatrix.write(DoT_ADDR, data, len);
}

void Command_Write(char com)
{
    Dotmatrix.write(DoT_ADDR, &com, 1);
}

void Dotmatrix_init(void)
{
    // Internal System Clock enable
    Command_Write((char)0x21);
    // INT/ROW output pin Set -> ROW Driver output
    Command_Write((char)0xA0);
    // Dimming Set -> 15
    Command_Write((char)0xEF);
    // Blinking Set -> off
    // Display Set -> on
    Command_Write((char)0x81);
}

void char_data_write(char data)
{
    uint8_t read_c, i, j, c_buff[8] = {0, 0, 0, 0, 0, 0, 0, 0};
    for(i=0; i<5; i++)
    {
        read_c = font[data-0x20][i];
        if(read_c)
        {
            for(j=0; j<8; j++)
            {
                if(read_c & (0x80 >> j))
                {
                    c_buff[j] |= (0x01 << (i+1));
                }
            }
        }
    }
    for(i=0; i<8; i++)
        Data_BUF[i*2+1] = c_buff[i];

    data_write(Data_BUF, 17);
}