#include "mbed.h"
#include "TextLCD.h"

// INA, INB, INT
PinName pin_DC[3] = {PA_6, PA_7, PA_8};

PwmOut INA(pin_DC[0]);
PwmOut INB(pin_DC[1]);
InterruptIn INT(pin_DC[2]);

// rs, rw, e, d0-d3
TextLCD lcd(PB_12, PB_13, PB_14, PB_15, PA_9, PA_10, PA_11); 

enum{STOP, CW, CCW};
uint16_t Int_Count = 0;

void DC_Ctrl(uint8_t dir, float Speed);
void INT_Count_ISR(void);

int main() {
    
    lcd.printf("    DC Motor\n");
    lcd.printf(" Volt :     [mV]"); 
    
    INT.rise(&INT_Count_ISR);
    
    while(1) {
        // CW
        for(int i=0; i<=100; i++)
        {
            DC_Ctrl(CW, i);
            wait(0.02);
        }
        DC_Ctrl(CW, 0);
        wait(2);
        lcd.locate(8, 1);
        lcd.printf("%4d", Int_Count);
        Int_Count = 0;
        // CCW
        for(int i=0; i<=100; i++)
        {
            DC_Ctrl(CCW, i);
            wait(0.02);
        }
        DC_Ctrl(CCW, 0);
        wait(2);
        lcd.locate(8, 1);
        lcd.printf("%4d", Int_Count);
        Int_Count = 0;
    }
}

void DC_Ctrl(uint8_t dir, float Speed)
{
    switch(dir)
    {
        case STOP:
            INA = 0;
            INB = 0;
            break;
        case CW:
            INA = Speed/100;
            INB = 0;
            break;
        case CCW:
            INA = 0;
            INB = Speed/100;
            break;
    }
}

void INT_Count_ISR(void)
{
    Int_Count++;
}