/*****Multiceiver wireless network*****/

#include "mbed.h"
#include "nRF24L01P.h"
 
Serial pc(USBTX, USBRX); // tx, rx
 
nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4);    // mosi, miso, sck, csn, ce, irq

//blue for pipe1 and green for pipe0
DigitalOut GreenLED(PTA12);
DigitalOut BlueLED(PTC8);
 
int main() {
    
    char count[1];
    char RxDataCnt_PIPE0, RxDataCnt_PIPE1;
    char temp;
    char pot1Val, pot2Val;
    
    //specifying address same as transmitter for pipe0 and pipe1
    long long RxAddress_PIPE1 = 0xE2E2E2E2E2;
    long long RxAddress_PIPE0 = 0xC2C2C2C2C2;
    
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2410);
    
    //set rx address with default address and for specified pipe
    my_nrf24l01p.setRxAddress(RxAddress_PIPE1, DEFAULT_NRF24L01P_ADDRESS_WIDTH, NRF24L01P_PIPE_P1);
    my_nrf24l01p.setRxAddress(RxAddress_PIPE0, DEFAULT_NRF24L01P_ADDRESS_WIDTH, NRF24L01P_PIPE_P0);
    
 
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    
    //display rx address for both pipes
    pc.printf( "nRF24L01+ RX Address - PIPE0  : 0x%010llX\r\n", my_nrf24l01p.getRxAddress(NRF24L01P_PIPE_P0) );
    pc.printf( "nRF24L01+ RX Address - PIPE1  : 0x%010llX\r\n", my_nrf24l01p.getRxAddress(NRF24L01P_PIPE_P1) );
 
    pc.printf( "Wireless Sensor Network - Multiceiver\r\n" );
    
    RxDataCnt_PIPE0 = 1;
    RxDataCnt_PIPE1 = 1;
    
    //set transfer size explicitly for both pipes
    my_nrf24l01p.setTransferSize(RxDataCnt_PIPE1, NRF24L01P_PIPE_P1);
    my_nrf24l01p.setTransferSize(RxDataCnt_PIPE0, NRF24L01P_PIPE_P0);
    
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
 
    while (1) {
        
        //check if data is available in pipe0
        if ( my_nrf24l01p.readable(NRF24L01P_PIPE_P0) ) {
 
            // ...read the data into the receive buffer
            temp = my_nrf24l01p.read( NRF24L01P_PIPE_P0, count, RxDataCnt_PIPE0 );
            
            pot1Val = count[0];
 
            //pc.printf("Received: %d bytes from PIPE0; POT=%d\r\n",temp, count[0]);
            
            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            GreenLED = !GreenLED;
        }
        
        //check if data is there in pipe1
        if ( my_nrf24l01p.readable(NRF24L01P_PIPE_P1) ) {
 
            // ...read the data into the receive buffer
            temp = my_nrf24l01p.read( NRF24L01P_PIPE_P1, count, RxDataCnt_PIPE1 );
            
            pot2Val = count[0];
 
            //pc.printf("Received: %d bytes from PIPE1; POT=%d\r\n",temp, count[0]);
            
            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            BlueLED = !BlueLED;
        }
        wait_ms(100);
        pc.printf("$%d %d;", pot1Val, pot2Val);
    }
}