#include "mbed.h"
Serial pc(USBTX, USBRX); // tx, rx
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalIn butt = (USER_BUTTON);

DigitalOut CLK(PA_3);
DigitalIn DATA(PD_7);

int readSSI(DigitalOut CLK, DigitalIn DATA){
    int i,tmp,numBits = 13; 
    int angle = 0b00000000000000; //Initialise 13 bit 0 binary
    CLK=1; //Bring CLK high
    for(i =0;i<numBits;i++){
         CLK = 0;        
         wait_us(10);
         CLK =1;
         wait_us(10); //CLK cycle
         tmp = DATA.read(); 
         angle = angle<<1; //Shift previous read bits
         angle += tmp; //Add new bit
    }    
    wait_us(16); //Timeout 16us from datasheet
    CLK =0; 
    return angle;
}


int angle; 
 
int main() {
    while(butt == 0){   //Startup readings
        led1 =!led1; 
        led2=!led2; 
        led3=!led3; 
        wait(0.1f);
    }
    wait(0.5f);
    printf("\r\n Start");
    
    while(1){
        printf("\r\n");
        CLK =0;
        angle = readSSI(CLK, DATA);
        printf("\r\n%d\r\n",angle);
        wait(.5f);
    }
}


