
// TCP Echo server
// 2010/9/7


/*

(Execute Sample)
PC side:
telnet 192.168.0.25 12345
Trying 192.168.0.25...
Connected to 192.168.0.25.
Escape character is '^]'.

mbed side:
Setup OK
mbed IP Address is 192.168.0.25
Binding..
Listening...
Listening: TCP Socket Accepted
Listening: Incoming TCP connection from 192.168.0.7
TCP Socket Readable
Received&Wrote:test text

TCP Socket Writable


*/


//##############  INCLUDE FILES  ##############//
#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"
#include "ADXL345_I2C.h"
#include "L3G4200D.h"
//#############################################//

//##############     DEFINES     ##############//
#define TCP_LISTENING_PORT 1337
#define PI 3.14159265
//#############################################//

//##############    VARIABLES    ##############//
double  x_cor       = 0, 
        y_cor       = 0, 
        cont[2]     = {0,0};
int     print       = 0,
        go          = 0,
        calibrated  = 0;
int  gyro_val[3] = {0,0,0};
//#############################################//

//##############PIN CONFIGURATION##############//
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
DigitalIn init(p5);
DigitalIn calibrate(p20);
I2C i2c(p9, p10); // sda, scl
ADXL345_I2C acc(p9, p10);
L3G4200D gyro(p9, p10);
//#############################################//

//##############    PROTOTYPES   ##############//
void tcp_send(const char*);
void tcp_sendIfConnected( const char* data );
void onConnectedTCPSocketEvent(TCPSocketEvent e);
void onListeningTCPSocketEvent(TCPSocketEvent e);
double getAngle(char axis, int precision);
void getI2CAddress();
//#############################################//

//############## ETHERNET CONFIG ##############//
// EthernetNetIf eth;
EthernetNetIf eth(
    IpAddr(192,168,0,16), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(192,168,0,2), //Gateway
    IpAddr(192,168,0,2)  //DNS
);

TCPSocket ListeningSock;
TCPSocket* pConnectedSock; // for ConnectedSock
Host client;
TCPSocketErr err;
//#############################################//

Ticker routine;

//##############    INTERRUPT    ##############//
void interrupt() 
{
    if(go){
        if(calibrated){
            if(print){
 //               char buffer [128];
 //               sprintf (buffer, "x:%f - y:%f\n",cont[0],cont[1]);
 //               tcp_send(buffer);  
                char buffer [128];
                sprintf (buffer, "x:%i - y:%i - z:%i\n",gyro_val[0],gyro_val[1],gyro_val[2]);
                tcp_send(buffer);
                print = 0;
            }
        }
    }
}
//#############################################//

//##############       MAIN      ##############//
int main() {
    //##############ETHERNET&TCP INIT##############//
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        return -1;
    }    
    IpAddr ip = eth.getIp();    
    // Set the callbacks for Listening
    ListeningSock.setOnEvent(&onListeningTCPSocketEvent);    
    // bind and listen on TCP
    err=ListeningSock.bind(Host(IpAddr(), TCP_LISTENING_PORT));
    if(err)
    {
        //Deal with that error...
    }    
    err=ListeningSock.listen(); // Starts listening
    if(err)
    {
        //listening error
    }
    //#############################################//
    
    //#############ACCELEROMETER INIT##############//
    //Go into standby mode to configure the device.
    acc.setPowerControl(0x00);
    //Full resolution, +/-16g, 4mg/LSB.
    acc.setDataFormatControl(0x00);    
    //3.2kHz data rate.
    acc.setDataRate(ADXL345_3200HZ);
    //Measurement mode.
    acc.setPowerControl(0x08);
    wait(0.1);
    //#############################################//
    
    //##################GYRO INIT##################//
    
    
    //#############################################//
    
    Timer tmr;
    tmr.start();
    
    while(true)
    {
        Net::poll();
        while(init)
        {
            if(!init)
            {
                tcp_send("You are a go!\n");
                led3 = 1;
                go = 1;
            }
        }
        if(tmr.read() > 0.2) // sec
        {
            led4=!led4; //Show that we are alive
            tmr.reset();
        }
/*        if(calibrate){
            while(calibrate){};
            char buffer [128];
            sprintf (buffer, "Calibrated\n");
            tcp_send(buffer);
            
            
            x_cor = getAngle('x',100);//-90
            y_cor = getAngle('y',100);//-90
           
            char buffer [128];
            sprintf (buffer, "Calibration values:\n");
            tcp_send(buffer);
            sprintf (buffer, "x:%f - y:%f\n",x_cor, y_cor);
            tcp_send(buffer); 
            sprintf (buffer, "------------------------\n");
            tcp_send(buffer);
             
            calibrated = 1;
            
            wait(0.1);
            
            routine.attach_us(&interrupt,10);
        }
        if(calibrated){

//            cont[0] = getAngle('x',10) - x_cor;
 //           cont[1] = getAngle('y',10) - y_cor;
            gyro.read(gyro_val);
            print = 1;
        }*/
        if(go){
            gyro.read(gyro_val);
            char buffer [128];
            sprintf (buffer, "x:%i - y:%i - z:%i\n",gyro_val[0],gyro_val[1],gyro_val[2]);
            tcp_send(buffer);
        }
        
    }  
}
//#############################################//

//##############   SUBROUTINES   ##############//

void tcp_send( const char* data ){
    int len = strlen(data);
    pConnectedSock->send(data, len);
}

void onConnectedTCPSocketEvent(TCPSocketEvent e)
{
   switch(e)
    {
    case TCPSOCKET_CONNECTED:
        break;
    case TCPSOCKET_WRITEABLE:
      //Can now write some data...
        printf("TCP Socket Writable\r\n");
        break;
    case TCPSOCKET_READABLE:
        //Can now read dome data...
        // Read in any available data into the buffer
        //char buff[128];
        //while ( int len = pConnectedSock->recv(buff, 128) ) {
        // And send straight back out again
        //   pConnectedSock->send(buff, len);
        //   buff[len]=0; // make terminater
        //}
        break;
    case TCPSOCKET_CONTIMEOUT:
        printf("TCP Socket Timeout\r\n");
        break;
    case TCPSOCKET_CONRST:
        printf("TCP Socket CONRST\r\n");
        break;
    case TCPSOCKET_CONABRT:
        printf("TCP Socket CONABRT\r\n");
        break;
    case TCPSOCKET_ERROR:
        printf("TCP Socket Error\r\n");
        break;
    case TCPSOCKET_DISCONNECTED:
    //Close socket...
        printf("TCP Socket Disconnected\r\n");        
        pConnectedSock->close();
        break;
    default:
        printf("DEFAULT\r\n"); 
      }
}

void onListeningTCPSocketEvent(TCPSocketEvent e)
{
    switch(e)
    {
    case TCPSOCKET_ACCEPT:
        printf("Listening: TCP Socket Accepted\r\n");
        // Accepts connection from client and gets connected socket.   
        err=ListeningSock.accept(&client, &pConnectedSock);
        if (err) {
            printf("onListeningTcpSocketEvent : Could not accept connection.\r\n");
            return; //Error in accept, discard connection
        }
        // Setup the new socket events
        pConnectedSock->setOnEvent(&onConnectedTCPSocketEvent);
        // We can find out from where the connection is coming by looking at the
        // Host parameter of the accept() method
        IpAddr clientIp = client.getIp();
        printf("Listening: Incoming TCP connection from %d.%d.%d.%d\r\n", 
           clientIp[0], clientIp[1], clientIp[2], clientIp[3]);
       break;
    // the following cases will not happen
    case TCPSOCKET_CONNECTED:
        printf("Listening: TCP Socket Connected\r\n");
        break;
    case TCPSOCKET_WRITEABLE:
        printf("Listening: TCP Socket Writable\r\n");
        break;
    case TCPSOCKET_READABLE:
        printf("Listening: TCP Socket Readable\r\n");
        break;
    case TCPSOCKET_CONTIMEOUT:
        printf("Listening: TCP Socket Timeout\r\n");
        break;
    case TCPSOCKET_CONRST:
        printf("Listening: TCP Socket CONRST\r\n");
        break;
    case TCPSOCKET_CONABRT:
        printf("Listening: TCP Socket CONABRT\r\n");
        break;
    case TCPSOCKET_ERROR:
        printf("Listening: TCP Socket Error\r\n");
        break;
    case TCPSOCKET_DISCONNECTED:
    //Close socket...
        printf("Listening: TCP Socket Disconnected\r\n");        
        ListeningSock.close();
        break;
    default:
        printf("DEFAULT\r\n"); 
     };
}

double getAngle(char axis, int precision)
{
    int     measurement[3] = {0,0,0};
    double  x_temp  = 0,
            y_temp  = 0,
            z_temp  = 0,
            x_angle = 0,
            y_angle = 0;
            
    int     i;
    
    for(i=0;i<precision;i++)
    {
        acc.getOutput(measurement);
        x_temp = (int16_t)measurement[0];
        y_temp = (int16_t)measurement[1];
        z_temp = (int16_t)measurement[2];
        x_angle += x_temp/z_temp;
        y_angle += y_temp/z_temp; 
    }
    x_angle = x_angle/precision;
    y_angle = y_angle/precision;
//    x_angle = atan(x_angle) * 180 / PI;
//    y_angle = atan(y_angle) * 180 / PI;
    if(axis == 'x')return (atan(x_angle) * 180 / PI);//+90
    if(axis == 'y')return (atan(y_angle) * 180 / PI);//+90
}

void getI2CAddress()
{
    int count = 1;
    for (int address=0; address<256; address+=2) {
        if (!i2c.write(address, NULL, 0)) { // 0 returned is ok    
            char buffer [128];
            sprintf (buffer, "%i: - %i\n",count, address);
            tcp_send(buffer);
            count++;    
        }           
    }
}
