/*
    3/27/2018 mdot version 3.1.0, mbed version 5.7.4
*/

#include "dot_util.h"
#include "RadioEvent.h"
#include <string.h>
#include <cstdlib>
#include <stdlib.h>
 
#if ACTIVE_EXAMPLE == PEER_TO_PEER_EXAMPLE

/////////////////////////////////////////////////////////////////////////////
// -------------------- DOT LIBRARY REQUIRED ------------------------------//
// * Because these example programs can be used for both mDot and xDot     //
//     devices, the LoRa stack is not included. The libmDot library should //
//     be imported if building for mDot devices. The libxDot library       //
//     should be imported if building for xDot devices.                    //
// * https://developer.mbed.org/teams/MultiTech/code/libmDot-dev-mbed5/    //
// * https://developer.mbed.org/teams/MultiTech/code/libmDot-mbed5/        //
// * https://developer.mbed.org/teams/MultiTech/code/libxDot-dev-mbed5/    //
// * https://developer.mbed.org/teams/MultiTech/code/libxDot-mbed5/        //
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////
// * these options must match between the two devices in   //
//   order for communication to be successful
/////////////////////////////////////////////////////////////
static uint8_t network_address[] = { 0x00, 0x11, 0x22, 0x33 };
static uint8_t network_session_key[] = { 0x00, 0x11, 0x22, 0x33, 0x00, 0x11, 0x22, 0x33, 0x00, 0x11, 0x22, 0x33, 0x00, 0x11, 0x22, 0x33 };
static uint8_t data_session_key[] = { 0x33, 0x22, 0x11, 0x00, 0x33, 0x22, 0x11, 0x00, 0x33, 0x22, 0x11, 0x00, 0x33, 0x22, 0x11, 0x00 };

mDot* dot = NULL;
lora::ChannelPlan* plan = NULL;

Serial pc(USBTX, USBRX);


// Storage for int conversions
unsigned int i_Temperature;
unsigned int i_X;
unsigned int i_Y;
unsigned int i_Z;

// Storage for GPS
float f_longitude;
float f_latitude;
int hour;
int minutes;
int seconds;
int milliseconds;
int day;
int month;
int year;

// Storage for twos complement
unsigned int i2s_Temperature;
unsigned int i2s_X;
unsigned int i2s_Y;
unsigned int i2s_Z;

// Variables to receiving data
std::string whatData = "";
int i_whatData = 0;
std::string typeData = "";
unsigned int i_typeData = 0;
int whereDataTypeFlag = 0;
std::string s_temperature = "";
std::string s_XData = "";
std::string s_YData = "";
std::string s_ZData = "";

unsigned int twosComplement(unsigned int value, unsigned int resolutionMask,unsigned int bitMask);


class myEvent : public mDotEvent
{
 
public:
    myEvent() {}
 
    virtual ~myEvent() {
        }
 
    /*!
     * MAC layer event callback prototype.
     *
     * \param [IN] flags Bit field indicating the MAC events occurred
     * \param [IN] info  Details about MAC events occurred
     */
    virtual void MacEvent(LoRaMacEventFlags* flags, LoRaMacEventInfo* info) {
        
 
        if (flags->Bits.Rx) {
            
            //logDebug("Rx %d bytes", info->RxBufferSize);
            if (info->RxBufferSize > 0) {
                
             
                std::string data = mts::Text::bin2hexString(info->RxBuffer, info->RxBufferSize).c_str();
                
                
                
                // print RX data as string and hexadecimal 
                std::string rx((const char*)info->RxBuffer, info->RxBufferSize);
                pc.printf("Receive data: %s [%s]\r\n", rx.c_str(), data.c_str());
                pc.printf("Data is of length: %d\n\r", data.length());
                
                // whereDataTypeFlag = data.find("01");
                // s_temperature = data.substr(whereDataTypeFlag + 2, 4);
                // data.erase(0,6);
                
                // whereDataTypeFlag = data.find("02");
                // s_XData = data.substr(whereDataTypeFlag + 2, 4);
                
                // whereDataTypeFlag = data.find("03");
                // s_YData = data.substr(whereDataTypeFlag + 2, 4);
                
                // whereDataTypeFlag = data.find("04");
                // s_ZData = data.substr(whereDataTypeFlag + 2, 4);
                
                while(data != "")
                {
                    typeData = data.substr(0,2);
                    data.erase(0,2);
                    //whatData = data.substr(0,4);
                    //data.erase(0,4);
                    //i_whatData = atoi(typeData.c_str());
                    
                    i_typeData = strtoul(typeData.c_str(), NULL, 16);
                    switch(i_typeData)
                    {
                        // Temperature
                        case 1:
                            whatData = data.substr(0,4);
                            data.erase(0,4);
                            s_temperature = whatData;
                            i_Temperature = strtoul(whatData.c_str(),NULL, 16);
                            
                            break;
                            
                        // X Data
                        case 2: 
                            whatData = data.substr(0,4);
                            data.erase(0,4);
                            s_XData = whatData;
                            i_X = strtoul(whatData.c_str(), NULL, 16);
                            break;
                            
                        // Y Data
                        case 3:
                            whatData = data.substr(0,4);
                            data.erase(0,4);
                            s_YData = whatData;
                            i_Y = strtoul(whatData.c_str(), NULL, 16);
                            break;
                        
                        // Z Data
                        case 4:
                            whatData = data.substr(0,4);
                            data.erase(0,4);
                            s_ZData = whatData;
                            i_Z = strtoul(whatData.c_str(), NULL, 16);
                            break;
                        // Longitude
                        case 5:
                            whatData = data.substr(0,4);
                            data.erase(0,4);
                            f_longitude = atof(whatData.c_str());
                            break;
                            
                        // Latitude
                        case 6:
                            whatData = data.substr(0,4);
                            data.erase(0,4);
                            f_longitude = atof(whatData.c_str());
                            break;
                        
                        // Hour
                        case 7:
                            whatData = data.substr(0,4);
                            data.erase(0,4);
                            hour = strtoul(whatData.c_str(), NULL, 16);
                            break;
                        
                        // minutes
                        case 8:
                            whatData = data.substr(0,4);
                            data.erase(0,4);
                            minutes = atoi(whatData.c_str());
                            break;
                        
                        default:
                            break;
                            
                            
                    }
                    
                }
                
                // i_Temperature = strtoul(s_temperature.c_str(), NULL, 16);
                // i_X = strtoul(s_XData.c_str(), NULL, 16);
                // i_Y = strtoul(s_YData.c_str(), NULL, 16);
                // i_Z = strtoul(s_ZData.c_str(), NULL, 16);
                
                // 0x1FFF->only needs 13bits, 0x1000->13th bit is sign bit
                i2s_Temperature = twosComplement(i_Temperature, 0x1FFF, 0x1000);
                
                // 0x0FFF->resolution is 12bits, 0x0800->12th bit is sign bit
                i2s_X = twosComplement(i_X, 0x0FFF, 0x0800);
                i2s_Y = twosComplement(i_Y, 0x0FFF, 0x0800);
                i2s_Z = twosComplement(i_Z, 0x0FFF, 0x0800);
                
                // Stoi not in mbed
               // i_Temperature = std::stoi(s_temperature,nullptr,16);
               // i_X = std::stoi(s_XData,nullptr,16);
               // i_Y = std::stoi(s_YData,nullptr,16);
               // i_Z = std::stoi(s_ZData,nullptr,16);
                
                // atoi freezes
                // i_Temperature = std::atoi(s_temperature.c_str());
                // i_X = std::atoi(s_XData.c_str());
                // i_Y = std::atoi(s_YData.c_str());
                // i_Z = std::atoi(s_ZData.c_str());
                
                // pc.printf("Temperature is: %s\n\r", s_temperature);
                // pc.printf("X: %s \n\r", s_XData);
                // pc.printf("Y: %s \n\r", s_YData);
                // pc.printf("Z: %s \n\r", s_ZData);
                
                pc.printf("Temperature is: %d (%d)[%s]\n\r", i2s_Temperature, i_Temperature, s_temperature.c_str());
                pc.printf("X: %d (%d) [%s]\n\r", i2s_X, i_X, s_XData.c_str());
                pc.printf("Y: %d (%d) [%s]\n\r", i2s_Y, i_Y, s_YData.c_str());
                pc.printf("Z: %d (%d) [%s]\n\r", i2s_Z, i_Z, s_ZData.c_str());
                
                
                
                
                
                /*for(; it < 2; it++)
                {
                    whatData = strcat(whatData,data[it])
                }
                pc.printf("%s is the first 2 numbers\n\r", whatData);*/
                
            }
        }
    }
};

/*  
    @Param:
        value: pass by value, the value you want to evaluate for twos complement
        resolutionMask: declare at function call, hex representation of which bits are unneeded
        bitMask: declare at function call, hex representation of which bit is sign bit
    @return:
        unsigned int converted value, if needed
*/
unsigned int twosComplement(unsigned int value, unsigned int resolutionMask,unsigned int bitMask)
{
    if(value & bitMask)
    {
        value = ~value;
        value = value & resolutionMask;
        value += 1;
    }
    
    return value;
}

int main() {
    // Custom event handler for automatically displaying RX data
    //RadioEvent events;
    myEvent _event;
    
    uint32_t tx_frequency;
    uint8_t tx_datarate;
    uint8_t tx_power;
    uint8_t frequency_band;
    uint32_t receiveStatus;

    pc.baud(115200);

    mts::MTSLog::setLogLevel(mts::MTSLog::TRACE_LEVEL);
    

    plan = new lora::ChannelPlan_US915();

    logInfo("Now asserting");
    assert(plan);

    dot = mDot::getInstance(plan);
    assert(dot);

    logInfo("mbed-os library version: %d", MBED_LIBRARY_VERSION);

    // start from a well-known state
    logInfo("defaulting Dot configuration");
    dot->resetConfig();
    

    // make sure library logging is turned on
    dot->setLogLevel(mts::MTSLog::INFO_LEVEL);

    // attach the custom events handler
    //dot->setEvents(&events);
    dot->setEvents(&_event);

    // update configuration if necessary
    if (dot->getJoinMode() != mDot::PEER_TO_PEER) {
        logInfo("changing network join mode to PEER_TO_PEER");
        if (dot->setJoinMode(mDot::PEER_TO_PEER) != mDot::MDOT_OK) {
            logError("failed to set network join mode to PEER_TO_PEER");
        }
    }
    frequency_band = dot->getFrequencyBand();
    switch (frequency_band) {
        case lora::ChannelPlan::EU868_OLD:
        case lora::ChannelPlan::EU868:
            // 250kHz channels achieve higher throughput
            // DR_6 : SF7 @ 250kHz
            // DR_0 - DR_5 (125kHz channels) available but much slower
            tx_frequency = 869850000;
            tx_datarate = lora::DR_6;
            // the 869850000 frequency is 100% duty cycle if the total power is under 7 dBm - tx power 4 + antenna gain 3 = 7
            tx_power = 4;
            break;

        case lora::ChannelPlan::US915_OLD:
        case lora::ChannelPlan::US915:
        case lora::ChannelPlan::AU915_OLD:
        case lora::ChannelPlan::AU915:
            // 500kHz channels achieve highest throughput
            // DR_8 : SF12 @ 500kHz
            // DR_9 : SF11 @ 500kHz
            // DR_10 : SF10 @ 500kHz
            // DR_11 : SF9 @ 500kHz
            // DR_12 : SF8 @ 500kHz
            // DR_13 : SF7 @ 500kHz
            // DR_0 - DR_3 (125kHz channels) available but much slower
            tx_frequency = 915500000;
            tx_datarate = lora::DR_13;
            // 915 bands have no duty cycle restrictions, set tx power to max
            tx_power = 20;
            break;

        case lora::ChannelPlan::AS923:
        case lora::ChannelPlan::AS923_JAPAN:
            // 250kHz channels achieve higher throughput
            // DR_6 : SF7 @ 250kHz
            // DR_0 - DR_5 (125kHz channels) available but much slower
            tx_frequency = 924800000;
            tx_datarate = lora::DR_6;
            tx_power = 16;
            break;

        case lora::ChannelPlan::KR920:
            // DR_5 : SF7 @ 125kHz
            tx_frequency = 922700000;
            tx_datarate = lora::DR_5;
            tx_power = 14;
            break;

        default:
            while (true) {
                logFatal("no known channel plan in use - extra configuration is needed!");
                wait(5);
            }
            break;
    }
    // in PEER_TO_PEER mode there is no join request/response transaction
    // as long as both Dots are configured correctly, they should be able to communicate
    update_peer_to_peer_config(network_address, network_session_key, data_session_key, tx_frequency, tx_datarate, tx_power);

    // save changes to configuration
    logInfo("saving configuration");
    if (!dot->saveConfig()) {
        logError("failed to save configuration");
    }

    // display configuration
    display_config();
//
//#if defined(TARGET_XDOT_L151CC)
//    // configure the ISL29011 sensor on the xDot-DK for continuous ambient light sampling, 16 bit conversion, and maximum range
//    lux.setMode(ISL29011::ALS_CONT);
//    lux.setResolution(ISL29011::ADC_16BIT);
//    lux.setRange(ISL29011::RNG_64000);
//#endif

    
    while (true) {
        
        std::vector<uint8_t> rx_data;
        
        // join network if not joined
        if (!dot->getNetworkJoinStatus()) {
            join_network();
        }

        
            
    }
 
    return 0;
}

#endif

