#include "mbed.h"
#include "HEPTA_CDH.h"
#include "HEPTA_EPS.h"
#include "HEPTA_SENSOR.h"
#include "HEPTA_COM.h"
HEPTA_CDH cdh(p5, p6, p7, p8, "sd");
HEPTA_EPS eps(p16,p26);
HEPTA_SENSOR sensor(p17,
                  p28,p27,0x19,0x69,0x13,
                  p13, p14,p25,p24);
HEPTA_COM com(p9,p10);
DigitalOut condition(LED1);
Serial sat(USBTX,USBRX,9600);
Timer sattime;
int rcmd = 0,cmdflag = 0; //command variable
//getting command and flag
void commandget()
{
    rcmd = sat.getc();
    cmdflag = 1;
}
//interrupting 
void receive(int rcmd, int cmdflag)
{
    sat.attach(commandget,Serial::RxIrq);
}

int main() {
    sat.printf("HEPTA-Sat Debug Program start\r\n");
    while(1){
        sat.printf("Please sellect a mode bellow\r\n");
        sat.printf("========================================\r\n");
        sat.printf("a: Check saving to SD card Mode\r\n");
        sat.printf("b: Check the battery voltage Mode\r\n");
        sat.printf("c: Check the temp sensor Mode\r\n");
        sat.printf("d: Check the 9 axis Mode\r\n");
        sat.printf("e: Check GPS rawdata Mode\r\n");
        sat.printf("f: Chec Camera snapchat Mode\r\n");
        sat.printf("g: \r\n");
        sat.printf("========================================\r\n");
        int rcmd=0,cmdflag=0;  //command variable
        sattime.start();
        eps.turn_on_regulator();//turn on 3.3V conveter
        //for(int i = 0; i < 100; i++) {
        rcmd = sat.getc();
        cmdflag = 1;
        //receive(rcmd,cmdflag);
        
        //satellite condition led
        condition = !condition;
        //Contents of command
        if (cmdflag == 1) {
            if (rcmd == 'a') {
                //SD mode
                char str[100];
                mkdir("/sd/mydir", 0777);
                FILE *fp = fopen("/sd/mydir/test.txt","w");
                if(fp == NULL) {
                    error("Could not open file for write\r\n");
                }
                for(int i=0; i<10; i++)fprintf(fp,"Hello my name is HEPTA!\r\n");
                fclose(fp);
                fp = fopen("/sd/mydir/test.txt","r");
                for(int j = 0; j < 10; j++) {
                    fgets(str,100,fp);
                    sat.puts(str);
                }
                fclose(fp);
                sat.printf("Goodbye!!\r\n");
            }else if (rcmd == 'b') {
                float bt;
                for(int i = 0; i < 10; i++) {
                    eps.vol(&bt);
                    sat.printf("Vol = %f\r\n",bt);
                    wait(0.5);
                }        
            }else if (rcmd == 'c') {        
                //Please insert your answer
                float temp;
                for (int i=0;i<10;i++) {
                    sensor.temp_sense(&temp);
                    sat.printf("temp = %f\r\n",temp);
                    wait(0.5);
                }
            }else if (rcmd == 'd') {
                //Please insert your answer
                float ax,ay,az;
                float gx,gy,gz;
                float mx,my,mz;
                for(int i = 0; i<10; i++) {
                    sensor.sen_acc(&ax,&ay,&az);
                    sat.printf("acc : ax= %f, ay= %f, az= %f\r\n",ax,ay,az);
                    sensor.sen_gyro(&gx,&gy,&gz);
                    sat.printf("gyro: gx= %f, gy= %f, gz= %f\r\n",gx,gy,gz);
                    sensor.sen_mag(&mx,&my,&mz);
                    sat.printf("mag : mx= %f, my= %f, mz= %f\r\n",mx,my,mz);
                    wait(0.5);
                }
            }else if (rcmd == 'e') {
                //Please insert your answer
                sensor.gps_setting();
                sat.printf("GPS Raw Data Mode\r\n");
                while(1) sat.putc(sensor.getc());
            }else if (rcmd == 'f') { 
                FILE *dummy = fopen("/sd/dummy.txt","w");
                if(dummy == NULL) {
                    error("Could not open file for write\r\n");
                }
                fclose(dummy);
                
                sat.printf("Camera Snapshot Mode\r\n");
                sat.printf("Hit Any Key To Take Picture\r\n");
                while(!sat.readable()) {}
                sensor.Sync();
                sensor.initialize(HeptaCamera_GPS::Baud115200, HeptaCamera_GPS::JpegResolution320x240);
                sensor.test_jpeg_snapshot_picture("/sd/test.jpg");
            }else if (rcmd == 'g'){
                sat.printf("Xbee Count Up Mode\r\n");
                for(int i = 0; i < 10; i++) {
                    com.printf("num = %d\r\n",i);
                    wait(0.5);
                }
            }
            rcmd=0,cmdflag=0;
        }
    //}
    }
}
