#include "mbed.h"
#include "SDFileSystem.h"
Serial pc(USBTX,USBRX,9600);
DigitalOut myled[]={LED1, LED2, LED3};
DigitalOut myled_[] = {PB_1};//この文の"PA_5,PA_6"が入ると6軸センサが動かなくなる
AnalogIn eps(PA_0);
AnalogIn tem(PA_7);
DigitalOut conv(PA_4);
I2C i2c(PB_7,PB_6);
SDFileSystem sd(PB_5, PB_4, PB_3, PA_8, "sd");//PB_3はLED3と接続されているため, PB_3の記述があるとLED3は機能しない.
Serial xbee(PA_9,PA_10);

const int addr_accel_gyro = 0xD0;
char cmd[2];
char data[1];
char xh[1];
char xl[1];

int rcmd=0;
int cmdflag=0;
double bt;
double temper;



void commandget(){
    rcmd    = pc.getc();
    cmdflag = 1;
}

void initialize(){
    rcmd = 0; 
    cmdflag = 0;
    conv = 0;
    pc.printf("initialize!\r\n");
}

void flash(){
    pc.printf("Start LED flashing!\r\n");
    for (int i=0; i<10; i++) {
        myled[2] = 1;
        myled_[0] = 1;
        //myled_[1] = 1;
        wait(0.5);
        myled[2] = 0;
        myled_[0] = 0;
        //myled_[1] = 0;
        wait(0.5);
    }
}

void voltageget(){
    pc.printf("Get voltage!\r\n");
    for (int i=0; i<10; i++) {
        bt = (eps.read()*1.431*3.3);
        pc.printf("Vol = %f\r\n",bt);
        wait(0.5);
    }
}

void tempget(){
    wait(0.5);
    for(int i = 0; i<10; i++) {
        temper = (tem.read()*3.3-0.6)*100;
        pc.printf("Tem=%f\r\n",temper);
        wait(0.5);
    }
}

void converter_high(){
    conv = 1;
}

void zaxisget(){
    conv = 1;
    char cmdd;
    wait(2);
    i2c.frequency(100000);
    data[0] = 0x75;
    i2c.write(addr_accel_gyro,data,1);
    i2c.read(addr_accel_gyro|0x01,xh,1);
    pc.printf("xh = 0x%02X\r\n",xh[0]);
    while(1){
        cmdd = pc.getc();
        if(cmdd == 'a'){
            data[0] = 0x75;
            i2c.write(addr_accel_gyro,data,1);
            i2c.read(addr_accel_gyro|0x01,xh,1);
            pc.printf("xh = 0x%02X\r\n",xh[0]);
            
            cmd[0]=0x6B;
            cmd[1]=0x00;
            i2c.write(addr_accel_gyro,cmd,2);
            
            cmd[0]=0x6C;
            cmd[1]=0x00;
            i2c.write(addr_accel_gyro,cmd,2);
            
            
            cmd[0] = 0x37;
            cmd[1] = 0x02;
            i2c.write(addr_accel_gyro,cmd,2);
            
            
            for(int i = 0; i<10; i++) {
                //data[0] = 0x3F;
                data[0] = 0x3B;//xh
                i2c.write(addr_accel_gyro,data,1);
                i2c.read(addr_accel_gyro|0x01,xh,1);
                //data[0] = 0x40;
                data[0] = 0x3C;//xl
                i2c.write(addr_accel_gyro,data,1);
                i2c.read(addr_accel_gyro|0x01,xl,1);
                //pc.printf("xh = 0x%02X,xl = 0x%02X\r\n",xh[0],xl[0]);
                double  acc_ax = short((xh[0]<<8) | (xl[0]));
                double AX = (acc_ax)*4/32764*9.81;
                pc.printf("AZ = %f\r\n",AX);
                wait(0.5);
            }
        }
        if(cmdd == 'b'){
            break;
        }
    }
}

void savetosd(){
    pc.printf("Hello World!\n");

    mkdir("/sd/mydir", 0777);

    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\r\n");
    }
    fprintf(fp, "Hello fun SD Card World!ryusuke!!!");
    fclose(fp);

    pc.printf("Goodbye World!\r\n");
}

void xbeecountup(){
    xbee.baud(9600);
    pc.printf("Xbee Count Up Mode\r\n");
    for(int i = 0; i < 10; i++) {
        xbee.printf("num = %d\r\n",i);
        pc.printf("num = %d\r\n",i);
        pc.printf("%c\r\n",xbee.getc());
        wait(1.0);
    }
}


int main(){
    pc.printf("hello world\r\n");
    while(1){
        commandget();
        if(cmdflag == 1){
            if(rcmd == 'a'){
                flash();
            }
            if(rcmd == 'b'){
                voltageget();
            }
            if(rcmd == 'c'){
                converter_high();
                tempget();
            }
            if(rcmd == 'd'){
                zaxisget();
            }
            if(rcmd == 'e'){
                savetosd();
            }
            if(rcmd == 'f'){
                xbeecountup();
            }
            if(rcmd == 'g'){
                pc.printf("conv on\r\n");
                converter_high();
                wait(10.0);
            }
            
        }
        wait(1.0);
        initialize();
    }
    pc.printf("exit, goodbye\r\n");
}

