#include "mbed.h"
#include "HEPTA_EPS.h"
#include "HEPTA_CDH.h"
#include "HEPTA_SENSOR.h"
#include "HEPTA_COM.h"
#include "LPS.h"
HEPTA_CDH cdh(PB_5, PB_4, PB_3, PA_8, "sd");
HEPTA_EPS eps(PA_0,PA_4);
HEPTA_SENSOR sensor(PA_7,PB_7,PB_6,0xD0);
HEPTA_COM com(PA_9,PA_10,9600);
DigitalOut condition(PB_1);
DigitalOut analog_switch(PA_3);
Serial sat(USBTX,USBRX, 9600);
//I2C i2c(PB_7, PB_6);
I2C i2c(D4,D5);
Timer sattime;

LPS ps(i2c);
DigitalOut sp1(PA_1);
Ticker press;
Ticker sound;
int flag = 0;            //condition flag
float batvol, temp;      //voltage, temperature 
int rcmd=0,cmdflag=0;    //command variable
int i, ct = 0;
float pressure = 0.0, altitude = 0.0, temperature = 0.0;
float ax,ay,az,gx,gy,gz;
char cmd1,cmd2,cmd3;
int oto = 0;
#define mC 261.626
#define mD 293.665
#define mE 329.628
#define mF 349.228
#define mG 391.995
#define mA 440.000
#define mB 493.883
float mm[]={mC*4,mD*4,mE*4,mF*4,mG*4,mA*4,mB*4,mC*8};   //timbre

void tick(void)
{
    sp1.write(oto);
    oto=!oto;
}

void pre() {
    com.printf("HEPTASAT::Time = %.4f [s], batvol = %.4f [V], temp = %.4f [deg C], altitude = %.4f [m]\r\n",sattime.read(),batvol,temp,altitude);
    com.printf("        ::ax = %.4f, ay = %.4f, az = %.4f, gx = %.4f, gy = %.4f, gz = %.4f\r\n",ax,ay,az,gx,gy,gz);   
    
}

int main()
{
    sat.printf("From Sat : Nominal Operation\r\n");
    com.printf("From Sat : Nominal Operation\r\n");
    sattime.start();
    eps.turn_on_regulator(); //turn on 3.3V conveter  
    analog_switch = 1;       //turn on analog switch (transceiver mode)
    
    mkdir("/sd/mydir", 0777);
    FILE *fp = fopen("/sd/mydir/sdtest.csv", "w");
    if(fp == NULL) {
        error("Could not open file for write\r\n");
    }
    fclose(fp);
    
    // initialize the pressure sensor 
    if (!ps.init()){
        printf("Failed to autodetect pressure sensor!\r\n");
        while (1);
    }
    ps.enableDefault();     // setting the pressure sensor 
    while(1){
        com.xbee_receive(&rcmd,&cmdflag);
        if(cmdflag == 1){
            if(rcmd == 'm'){
                com.initialize(); //initializing
                FILE *fp = fopen("/sd/mydir/sdtest.csv", "a");
                int count = 0;
                press.attach(&pre, 1.0);
                while(1){
                    com.xbee_receive(&rcmd,&cmdflag);
                    //satellite condition led
                    condition = !condition;
                    //sensing HK data
                    eps.vol(&batvol);
                    sensor.temp_sense(&temp);
                    
                    //sensing the 
                    sensor.sen_acc(&ax,&ay,&az);
                    sensor.sen_gyro(&gx,&gy,&gz);
                    pressure = ps.readPressureMillibars();
                    altitude = ps.pressureToAltitudeMeters(pressure);
                    temperature = ps.readTemperatureC();
                    //if((count % 10) == 0){
//                        com.printf("HEPTASAT::Time = %.4f [s], batvol = %.4f [V], temp = %.4f [deg C], altitude = %.4f [m]\r\n",sattime.read(),batvol,temp,altitude);
//                        com.printf("        ::ax = %.4f, ay = %.4f, az = %.4f, gx = %.4f, gy = %.4f, gz = %.4f\r\n",ax,ay,az,gx,gy,gz);
//                    }
                    fprintf(fp,"%f, %f, %f, %f, %f, %f, %f, %f, %f, %f\r\n",sattime.read(),batvol,temp,altitude,ax,ay,az,gx,gy,gz);
                    wait_ms(100);
                    if(rcmd == 'f'){
                        fclose(fp); 
                        press.detach();
                        sat.printf("finish sensing\r\n");
                        com.printf("finish sensing\r\n");
                        break;
                    } 
                    count++;
                }
            }
        }
        if(rcmd == 'e'){
            sat.printf("From Sat : End of while\r\n");
            com.printf("From Sat : End of while\r\n");
            com.initialize(); //initializing
            while(1){
                com.xbee_receive(&rcmd,&cmdflag);
                if(rcmd == 'z'){
                    oto = 0;
                    break;
                }
                for(i=0;i < sizeof(mm)/sizeof(mm[0]);i++) {
                    sound.attach(&tick,1.0/mm[i]/2.0);  //If warning appear, ignore
                    wait(0.5f);
                }
                sound.detach();
                i = 0;
            }
            break;
        }
        com.initialize(); //initializing
    }
    sattime.stop();
    sat.printf("From Sat : End of operation\r\n");
    com.printf("From Sat : End of operation\r\n");
}