#ifndef KYUBE_BOARD_H
#define KYUBE_BOARD_H
//=========定数の設定=========//

//サンプリング周期[s]
#define SAMPLING_TIME 0.001f

//PWMの周期[ms]
#define PULSE_PERIOD_MS 0.5f

//ラインセンサの処理
#define LINE_ERROR 35.0f    //無視する偏差の閾値
#define LINE_GAIN 5.6f      //外側のセンサにかけるゲイン

//ラインセンサPIDゲイン
#define LINE_KP 4.8
#define LINE_KI 0.0
#define LINE_KD 0.075

//定常時の速度[パルス数/サンプリング周期]
#define DEFAULT_VELOCITY 3000.0f

//速度制御のPIDゲイン
#define VELO_KP 0.8
#define VELO_KI 8.5
#define VELO_KD 0.0

//=========ピンの設定=========//

/*-SM32F303K8-*/
#if defined(TARGET_STM32F303K8)
//M1モータドライバ
#define M1_PHASE PB_5
#define M1_PWML PB_4

//M2モータドライバ
#define M2_PHASE PA_8
#define M2_PWML PA_11

//M1エンコーダ
#define M1_ENCODER_A PA_12
#define M1_ENCODER_B PB_0

//M2エンコーダ
#define M2_ENCODER_A PA_9
#define M2_ENCODER_B PA_10

//サーボモータ
#define SERVO_PLUSE PF_0

//距離センサ
#define SDA PB_7
#define SCL PB_6
#define VL53L0X_RESET PB_1

//SDカード
#define MOSI PA_7
#define MISO PA_6
#define SCLK PA_5
#define SEEL PA_4

//SDカード検出
#define SD_DETECTION PA_3

//タクトスイッチ
#define BUTTON PB_3

//アナログイン
#define ANALOG_LEFT_1 PA_0
#define ANALOG_RIGHT_1 PB_1
#define ANALOG_LEFT_2 PA_1
#define ANALOG_RIGHT_2 PA_3



/*---LPC1768---*/
#elif defined(TARGET_LPC1768)
//M1モータドライバ
#define M1_PHASE p21
#define M1_PWML p22

//M2モータドライバ
#define M2_PHASE p24
#define M2_PWML p23

//M1エンコーダ
#define M1_ENCODER_A p13
#define M1_ENCODER_B p14

//M2エンコーダ
#define M2_ENCODER_A p11
#define M2_ENCODER_B p12

//サーボモータ
#define SERVO_PLUSE p25

//距離センサ
#define SDA p9
#define SCL p10
#define VL53L0X_RESET p15

//SDカード
#define MOSI p5
#define MISO p6
#define SCLK p7
#define SEEL p8

//SDカード検出
#define SD_DETECTION p29

//タクトスイッチ
#define BUTTON p30

#endif//micon select

#endif//KYUBE_BOARD_H