/*
説明
Nucleo-F303K8とMicroSDを使ったデータ保存のサンプルプログラム

以下ピン配置
Nucleo  SDモジュール
GND-----VSS-----------0V
+3V3----VDD
D11-----CMD
D12-----DAT0
D13-----CLK
D9------CD
*/

#include "mbed.h"
#include "SDFileSystem.h"

SDFileSystem sd(D11, D12, D13, D9, "sd"); // the pinout on the mbed Cool Components workshop board
Serial pc(USBTX, USBRX);
Timer timer1;     //SD open
Timer timer2;     //SD 1byte wrinting
Timer timer3;     //SD 8byte writing
Timer timer4;     //SD close

int main(){
    int miri=1000;
    
    timer1.reset();
    timer1.start();
    FILE *fp = fopen("/sd/sdtest.txt", "w");
    timer1.stop();
    float t1=timer1.read();
    float time1=t1*miri;
    
    timer2.reset();
    timer2.start();
    fprintf(fp, "0");      //1byte writing
    timer1.stop();
    float t2=timer2.read();
    float time2=t2*miri;

    timer3.reset();
    timer3.start();
    fprintf(fp,"12345678");     //8byte writing
    timer1.stop();
    float t3=timer3.read();
    float time3=t3*miri;

    timer4.reset();
    timer4.start();
    fclose(fp);
    timer4.stop();
    float t4=timer4.read();
    float time4=t4*miri;
    pc.printf("time1= %f ms\ntime2= %f ms\ntime3= %f ms\ntime4= %f ms\n",time1,time2,time3,time4);
    free(fp);
}