#include "mbed.h"

BusOut myleds(LED1, LED2, LED3, LED4);       //BusOutライブラリ利用
Serial pc(USBTX, USBRX);

void isrRx(){              //受信割込みハンドラ
    char ch;
    ch = pc.getc();        //受信
     
    switch(ch){
        case '1':          //1のキー入力
            myleds=1;      //LED1点灯(2^0はLED1)
            break;
        case '2':          //2のキー入力
            myleds=2;      //LED2点灯(2^1はLED2)
            break;
        case '3':          //3のキー入力
            myleds=4;      //LED3点灯(2^2はLED3)
            break;
        case '4':          //4のキー入力
            myleds=8;      //LED4点灯(2^3はLED4)
            break;
    }
}

int main(){
    pc.baud(9600);         //クロックレート設定
    pc.printf("Let`s input on a keyboard between 1 and 4!!\n");
    
    while(1) {
        pc.attach(isrRx,Serial::RxIrq);       //割込み
        wait(0.1);
    }
}           
        