#include "mbed.h"
#include "Pulse.h"
#include "LM61CIZ.h"
#define echoPin D4
#define trigPin D5
#define TempPin A0

Serial pc(USBTX,USBRX);
AnalogIn temptemp(A0);
PulseInOut echo(echoPin);
PulseInOut trig(trigPin);
LM61CIZ Temp(TempPin);

long map(long x, long in_min, long in_max, long out_min, long out_max) {
  return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

double Duration = 0;
double Distance=0;


int main(){
    pc.baud(9600);
    while(1){
        int temp=Temp.getTemperature();
        trig.write_us(1,10);
        Duration=echo.read_high_us(5000);
        if(Duration>0){
            Duration=Duration/2;
            double sspead=331.5+0.6*temp;
            Distance=Duration*sspead*100/1000000;
            pc.printf("%d  %lfm\n",temp,Distance);
        }
        wait(0.01);
    }
}