#include "mbed.h"
#include "SO1602A.h"
#define select1_0 PB_4
#define select1_1 PB_5
#define select1_2 PB_3
#define select1_3 PB_1
#define select2_0 PF_0
#define select2_1 PF_1
#define select2_2 PA_8
#define select2_3 PA_11
#define select3_0 PA_4
#define select3_1 PA_5
#define select3_2 PA_7
#define select3_3 PA_6

#define Z0 PA_0
#define Z1 PA_1
#define Z2 PA_3

#define SDA PB_7
#define SCL PB_6

#define uartSEpin PA_2

DigitalOut uartSE(uartSEpin);

AnalogIn y1(Z0);
AnalogIn y2(Z1);
AnalogIn y3(Z2);

DigitalOut select1[]= {
    DigitalOut(select1_0),
    DigitalOut(select1_1),
    DigitalOut(select1_2),
    DigitalOut(select1_3),
};
DigitalOut select2[]= {
    DigitalOut(select2_0),
    DigitalOut(select2_1),
    DigitalOut(select2_2),
    DigitalOut(select2_3),
};
DigitalOut select3[]= {
    DigitalOut(select3_0),
    DigitalOut(select3_1),
    DigitalOut(select3_2),
    DigitalOut(select3_3),
};
Serial uart(PA_9,PA_10);
Serial pc(USBTX,USBRX);
I2C i2c(SDA,SCL);
SO1602A oled(i2c,0x78);

void PinSelect(int pin)
{
    bool selectnum[16][4]= {
        {0,0,0,0},
        {0,0,0,1},
        {0,0,1,0},
        {0,0,1,1},
        {0,1,0,0},
        {0,1,0,1},
        {0,1,1,0},
        {0,1,1,1},
        {1,0,0,0},
        {1,0,0,1},
        {1,0,1,0},
        {1,0,1,1},
        {1,1,0,0},
        {1,1,0,1},
        {1,1,1,0},
        {1,1,1,1},
    };
    if(pin<=15) {
        select1[0]=selectnum[pin][3];
        select1[1]=selectnum[pin][2];
        select1[2]=selectnum[pin][1];
        select1[3]=selectnum[pin][0];
        for(int i=0; i<=3; i++) {
            select2[i]=0;
            select3[i]=0;
        }
    } else if(pin<=31) {
        select2[0]=selectnum[pin-16][3];
        select2[1]=selectnum[pin-16][2];
        select2[2]=selectnum[pin-16][1];
        select2[3]=selectnum[pin-16][0];
        for(int i=0; i<=3; i++) {
            select1[i]=0;
            select3[i]=0;
        }
    } else if(pin<=47) {
        select3[0]=selectnum[pin-32][3];
        select3[1]=selectnum[pin-32][2];
        select3[2]=selectnum[pin-32][1];
        select3[3]=selectnum[pin-32][0];
        for(int i=0; i<=3; i++) {
            select1[i]=0;
            select2[i]=0;
        }
    }
}

void LineDataRead(int read[48])
{
    float anal[48];
    for(int i=0; i<=47; i++) {
        PinSelect(i);
        if(i<=15) {
            anal[i]=y1.read();
        } else if(i<=31) {
            anal[i]=y2.read();
        } else if(i<=47) {
            anal[i]=y3.read();
        }
//        pc.printf("%f ",anal[i]);

        if(anal[i]<0.8f) {
            read[i]=0;
        } else {
            read[i]=1;
        }
//        oled.printf("%.3f",read[i]);
        
    }
//    oled.printf("%d %f",read[0],anal[0]);
}

void DataTrim(char send[6],int data[48])
{
    send[0]=char((data[0]<<7)+(data[5]<<6)+(data[1]<<5)+(data[4]<<4)+(data[2]<<3)+(data[3]<<2)+(data[12]<<1)+(data[6]<<0));
    send[1]=char((data[13]<<7)+(data[7]<<6)+(data[14]<<5)+(data[15]<<4)+(data[22]<<3)+(data[11]<<2)+(data[23]<<1)+(data[10]<<0));
    send[2]=char((data[8]<<7)+(data[9]<<6)+(data[16]<<5)+(data[21]<<4)+(data[17]<<3)+(data[20]<<2)+(data[18]<<1)+(data[19]<<0));
    send[3]=char((data[27]<<7)+(data[41]<<6)+(data[37]<<5)+(data[40]<<4)+(data[25]<<3)+(data[24]<<2)+(data[28]<<1)+(data[39]<<0));
    send[4]=char((data[29]<<7)+(data[38]<<6)+(data[30]<<5)+(data[31]<<4)+(data[32]<<3)+(data[37]<<2)+(data[33]<<1)+(data[36]<<0));
    send[5]=char((data[34]<<7)+(data[35]<<6)+(data[42]<<5)+(data[47]<<4)+(data[43]<<3)+(data[46]<<2)+(data[44]<<1)+(data[45]<<0));
    for(int i=0; i<=5; i++) {
        uart.putc(send[i]);
    }
    for(int i=0; i<=47; i++) {
//        oled.printf("%d",data[i]);
    }
//    oled.printf("%d",send[0]);
}


void printoled(char printdata[6])
{
    int trimdata[48];
    for(int i=0; i<=47; i++) {
        if(i<=7) {
            trimdata[i]=((printdata[0] << i) & 0b10000000)>>7;
        } else if(i<=15) {
            trimdata[i]=((printdata[1] << i-8) & 0b10000000)>>7;
        } else if(i<=23) {
            trimdata[i]=((printdata[2] << i-16) & 0b10000000)>>7;
        } else if(i<=31) {
            trimdata[i]=((printdata[3] << i-24) & 0b10000000)>>7;
        } else if(i<=39) {
            trimdata[i]=((printdata[4] << i-32) & 0b10000000)>>7;
        } else if(i<=47) {
            trimdata[i]=((printdata[5] << i-40) & 0b10000000)>>7;
        }
    }
    int LAN[8];
    for(int i=0; i<=7; i++) {
        LAN[i]=!trimdata[i]*-2+!trimdata[i+2]*2+!trimdata[i+4]*-1+!trimdata[i+5]*1;
    }
    oled.locate(0,0);
    oled.printf("%+2d  %+2d  %+2d  %+2d  %+2d  %+2d  %+2d  %+2d",LAN[0],LAN[1],LAN[2],LAN[3],LAN[4],LAN[5],LAN[6],LAN[7]);
}
int readdata[48];
char uartdata[6];
void Initialize()
{
    for(int i=0; i<=47; i++) {
        readdata[i]=0;
    }
    for(int i=0; i<=5; i++) {
        uartdata[i]=0x00;
    }
}

int main()
{
    pc.baud(9600);
    uart.baud(38400);
    Initialize();
    uartSE=1;
    oled.init();
    oled.setDispFlag(true,false,false);
    while(1) {
        LineDataRead(readdata);
        DataTrim(uartdata,readdata);
        printoled(uartdata);
        wait(0.01);
    }
}
