#ifndef ACTUATORHUB_H_
#define ACTUATORHUB_H_

#include "../../../CommonLibraries/RingBuffer/RingBuffer.h"

extern RINGBUFFER::RingBuffer RS485SendBuffer;
extern RINGBUFFER::RingBuffer BluetoothSendBuffer;

namespace ACTUATORHUB {
    #define MOTOR_ADDR      'M'
    #define MOTOR2_ADDR     'N'
    #define MOTOR3_ADDR     'O'
    #define SOLENOID_ADDR   'S'
    #define BLUETOOTH_ADDR  'B'
    #define TAPELED_ADDR    'L'

    namespace MOTOR {
        #define FREE    0
        #define BACK    1
        #define FOR     2
        #define BRAKE   3

        typedef struct {
            uint8_t dir;
            uint8_t pwm;
        }MotorStatus;

        typedef union {
            struct {
                int data3 : 2;
                int data2 : 2;
                int data1 : 2;
                int data0 : 2;
            };
            uint8_t all;
        }MotorDirectionData;

        typedef struct {
            MotorDirectionData direction0to3;
            MotorDirectionData direction4to7;
            MotorDirectionData direction8to9;

            uint8_t pwm0;
            uint8_t pwm1;
            uint8_t pwm2;
            uint8_t pwm3;
            uint8_t pwm4;
            uint8_t pwm5;
            uint8_t pwm6;
            uint8_t pwm7;
            uint8_t pwm8;
            uint8_t pwm9;
            uint8_t pwm10;
            uint8_t pwm11;
            uint8_t pwm12;
        }AllMotorData;

        class Motor {
            public:
            static void Initialize();
            static void Update(MotorStatus *status);
            static void SetDefault();
        };
    }

    namespace SOLENOID {
        #define SOLENOID_ON     1
        #define SOLENOID_OFF    0

        #define ALL_SOLENOID_ON     0xffff
        #define ALL_SOLENOID_OFF    0

        typedef union {
            struct {
                int : 4;
                int solenoid11 : 1;
                int solenoid10 : 1;
                int solenoid9 : 1;
                int solenoid8 : 1;
                int solenoid7 : 1;
                int solenoid6 : 1;
                int solenoid5 : 1;
                int solenoid4 : 1;
                int solenoid3 : 1;
                int solenoid2 : 1;
                int solenoid1 : 1;
                int solenoid0 : 1;
            };
            uint16_t all;
        }SolenoidStatus;

        class Solenoid {
            public:
            static void Initialize();
            static void Update(SolenoidStatus status);
        };
    }

    class ActuatorHub {
        public:
        static void Update();
    };
}

#endif
