               /*
 * PID.h
 *
 * Created: 2016/07/01 17:47:45
 *  Author: yuuki
 */ 


#ifndef PID_H_
#define PID_H_

namespace PID_SPACE
{
    class PID
    {
        private:
        double diff[2];
        double integral;
        double deltaTime;
        double dataRangeLower;
        double dataRangeUpper;
        double kp,ki,kd;
        double mv;
        
        public:
        // deltaTime:1サイクル時間( 1 / Process Frequency )
        PID(double deltaTime);
        PID(double deltaTime, double dataRangeLower, double dataRangeUpper);
        PID(double deltaTime, double dataRangeLower, double dataRangeUpper, double KP, double KI, double KD);
        
        //パラメータを設定
        void SetParam(double KP, double KI, double KD);
        
        //測定量を入力し操作量を取得
        double SetPV(double sensorData, double targetData);
        
        //操作量を取得
        double GetMV();
        
        //入力した値を制限して取得
        double limit(double data, double lower, double upper);

        //TODO:速度系PID関数
        double SetSpeed(double sensorData,double targetData);
    };
    
    
}



#endif /* PID_H_ */