//
//  MainMenu.cpp
//  menuSystem
//
//  Created by BradDSmith on 2013-02-26.
//  Copyright (c) 2013 BradDSmith. All rights reserved.
//

#include "Constantdisplay.h"

#include "console.h"

Constantdisplay::Constantdisplay()
{  
    maxitems = MAXCDISPLAYITEMS;
}

void Constantdisplay::setMaxCdisplayItems(int max)
{
    maxitems = max;
}

void Constantdisplay::setCdisplayItem(int locID, const char * CdisplayText, int x, int y, int x2, int y2)
{
   CdisplayItem[locID].initialize( (char *)CdisplayText,x, y, x2 ,y2);      
}

void Constantdisplay::printCdisplay()
{
    for (int i = 0; i < maxitems; i++) {
        CdisplayItem[i].print();
    }
}

void Constantdisplay::updatedisplayitem(int ID, char * updateText)
{
    CdisplayItem[ID].setValue(updateText);
}

void Constantdisplay::printrect(int ID, int x1, int y1, int x2, int y2)
{
    CdisplayItem[ID].Crect(x1, y1, x2, y2);
}
/*
void Constantdisplay::deleterect(int ID, int x1, int y1, int x2, int y2)
{
    CdisplayItem[ID].DeleteCrect(x1, y1, x2, y2);
}
*/
/* itoa:  convert n to characters in s */
 void Constantdisplay::itoa(int n, char s[])
 {
     int i, sign;
 
     if ((sign = n) < 0)  /* record sign */
         n = -n;          /* make n positive */
     i = 0;
     do {       /* generate digits in reverse order */
         s[i++] = n % 10 + '0';   /* get next digit */
     } while ((n /= 10) > 0);     /* delete it */
     if (sign < 0)
         s[i++] = '-';
     s[i] = '\0';
     reverse(s);
 }

void Constantdisplay::reverse(char *s)
{
    char *j;
    int c;
 
   j = s + strlen(s) - 1;
  while(s < j) {
    c = *s;
    *s++ = *j;
    *j-- = c;
  }
}



