#include "mbed.h"

#include "menuIDs.h"
#include "MainMenu.h"
#include "console.h"

extern BusInOut switches; //(p21, p22, p23, p24)
extern MainMenu pageMenu[MAXPAGES];
extern volatile bool exittorecord;

int PlayscreenPageHandler()
{
     int userSelection = 0;
     pageMenu[PLAYSCR].printMenu();

     unsigned char lastState = 0x0f;  //0000 1111
     bool exitCurrentMenu = false;

     while ( exitCurrentMenu == false)
        {
        
        unsigned char currentState = switches.read();  //reading a port add a AND MASK & 0b00000111
        wait_ms(10);
        if( currentState == switches.read() && currentState != lastState)
            {
            lastState = currentState; 
            switch(currentState)
                {
                case 0x0e:
                    pageMenu[PLAYSCR].erase();
                    printXY("                       ", 5, 10);    //erases the ACTION prompt
                    userSelection = PLAY;
                    exitCurrentMenu = true;
                    break;
                case 0x0d:
                     pageMenu[PLAYSCR].highlightPrevItem();
                    break;
                case 0x0b:
                     pageMenu[PLAYSCR].highlightNextItem();
                    break;
                case 0x07:
                    userSelection = pageMenu[PLAYSCR].getHighlightedItem() ;
                    break;
                }//eo select

                // is the user selection an ACTION  assigned to this page
/*                
                if (userSelection != 0 && userSelection > PLAYSCROFFSET)  //page selections are 0 through 12
                    {
                    // place code here to handle actions processed directly from this page
                    
                    // TODO ask Brad about this section ******************---------------------*************
                    switch(userSelection)
                        {
                    
                        case P_TRACKFILE :
                            printXY("Example Track selected          ", 5, 10); //***********---------------***************------------********** Discuss with Brad
                            //call function to perform task
                            break;
                  
                        }
                    
                    // eo place code here ......
                    userSelection = 0;
                    }
*/                    
                wait_ms(200);
                if (exittorecord == true)
                   break;
                
            }//eo if kbhit
        }//eo while
        return userSelection;
}