#include "mbed.h"

#include "menuIDs.h"
#include "MainMenu.h"
#include "console.h"

extern BusInOut switches; //(p21, p22, p23, p24)
extern MainMenu pageMenu[MAXPAGES ];
extern volatile bool exittorecord;
extern Serial pc;

int PlaybackmenuPageHandler()
{
     int userSelection = 0;
     pageMenu[PLAYBACK].printMenu();

     unsigned char lastState = 0x0f;  //0000 1111
     bool exitCurrentMenu = false;

     while ( exitCurrentMenu == false)
        {
        
        unsigned char currentState = switches.read();  //reading a port add a AND MASK & 0b00000111
        wait_ms(10);
        if( currentState == switches.read() && currentState != lastState)
            {
            lastState = currentState; 
            switch(currentState)
                {
                case 0x0e:
                    pageMenu[PLAYBACK].erase();
                    userSelection = HOME;
                    exitCurrentMenu = true;
                    break;
                case 0x0d:
                     pageMenu[PLAYBACK].highlightPrevItem();
                    break;
                case 0x0b:
                     pageMenu[PLAYBACK].highlightNextItem();
                    break;
                case 0x07:
                    pageMenu[PLAYBACK].erase();
                    
                    if (pageMenu[PLAYBACK].getHighlightedItem()== 702) userSelection = 9;
                    if (pageMenu[PLAYBACK].getHighlightedItem()== 701) userSelection = 8;
                    exitCurrentMenu = true;
       //             pc.printf("userselction: %d \n", userSelection);
         //           pc.printf("highlighteditem: %d \n", pageMenu[PLAYBACK].getHighlightedItem());
                    break;
                }//eo select
            wait_ms(200);
            if (exittorecord == true)
               break;
            
            }//eo if kbhit
        }//eo while
        return userSelection;
}