//
//  MainMenu.cpp
//  menuSystem
//
//  Created by BradDSmith on 2013-02-26.
//  Copyright (c) 2013 BradDSmith. All rights reserved.
//

#include "MainMenu.h"

#include "console.h"

MainMenu::MainMenu()
{
    selecteditem = 0;   //April 9th 2013 Ask Brad about Glitch
    highlightedItem = 0;
    maxitems = MAXITEMS;
    selectionstatus = false;
}

void MainMenu::setMaxItems(int max)
{
    maxitems = max;
}

void MainMenu::setMenuItem(int locID, int menuID, const char * menuText, int x, int y)
{
    if(locID <maxitems){
        menuItem[locID].initialize(menuID, (char *)menuText,x, y);
        }
}

void MainMenu::printMenu()
{
    const char * msg = Title.c_str();
    printXY( (char *)msg, 5, 0);
    for (int i = 0; i < maxitems; i++) {
        menuItem[i].print();
    }

   menuItem[highlightedItem].highlight();
   if (selectionstatus == true) 
   {
   menuItem[selecteditem].showselect();  //April 9th 2013 Ask Brad about Glitch
   }
}

void MainMenu::highlightNextItem()
{
    menuItem[highlightedItem].removeHighLight();
    
    highlightedItem++;
    if(highlightedItem >= maxitems)highlightedItem = 0;
  //   highlightedItem--;
  //   if(highlightedItem < 0)highlightedItem = maxitems - 1 ;
    
    menuItem[highlightedItem].highlight();
}

void MainMenu::highlightPrevItem()
{
    menuItem[highlightedItem].removeHighLight();
    
  highlightedItem--;
  if(highlightedItem < 0)highlightedItem = maxitems - 1 ;
  //  highlightedItem++;
 //   if(highlightedItem >= maxitems)highlightedItem = 0;
    
    menuItem[highlightedItem].highlight();
}

int MainMenu::getHighlightedItem()
{
    return menuItem[highlightedItem].getMenuID();
}

void MainMenu::erase()
{
       for (int i = 0; i < maxitems; i++) {
            menuItem[i].erase();
            }
}

void MainMenu::selection()
{
    selecteditem = highlightedItem;
    menuItem[selecteditem].showselect();
}

void MainMenu::removeselection()
{
    menuItem[selecteditem].removeselect();
}

string MainMenu::getTitle()
{
    return Title;
}
void MainMenu::setTitle(string NewTitle)
{
    Title = NewTitle;
}

void MainMenu::setselectstatus()
{
    selectionstatus = true;
}

int MainMenu::getselecteditem()
{
    return selecteditem;
}