#include "mbed.h"

#include "menuIDs.h"
#include "MainMenu.h"
#include "console.h"

extern BusInOut switches; //(p21, p22, p23, p24)
extern MainMenu pageMenu[MAXPAGES ];
extern volatile bool exittorecord;
Timer t;
Ticker printtime;


void displaytime(void)
{
    char tickertime[50];
    sprintf(tickertime, "Song Length:%4.2f", t.read()); 
    printXY(tickertime, 2, 2); 
}

int RecordscreenPageHandler()
{
     bool recordflag = true;
     
     char timebuf[50];
     
     
     clrscr();
     int userSelection = 0;
     unsigned char lastState = 0x0f;  //0000 1111
     bool exitCurrentMenu = false;
            
     printtime.attach(&displaytime, 1); 
 
     t.start();
                 
        
     while ( exitCurrentMenu == false)
        {   
            
        if (exittorecord == true && recordflag == true)
            {
            printXY("Recording", 5, 2);
  //         printXY("To Stop", 2, 5);
  //         printXY("Recording", 2, 6);
            recordflag = false;
            }
        unsigned char currentState = switches.read();  //reading a port add a AND MASK & 0b00000111
        wait_ms(10);
        if( currentState == switches.read() && currentState != lastState)
            {
            lastState = currentState; 
            switch(currentState)
                {
                case 0x0e:
                   if (exittorecord == false)
                   { 
                    pageMenu[RECORDSCR].erase();
                    printXY("                       ", 5, 10);    //erases the ACTION prompt
                    userSelection = HOME;
                    exitCurrentMenu = true;                  
                   } 
                   break;
                case 0x07:
                if (exittorecord == true)
                    {
                    clrscr();
                    t.stop();              
                    printtime.detach();
                    sprintf(timebuf, "Total Length:%4.2f", t.read());
                    printXY(timebuf, 2, 2);        
                    t.reset();            
                    exittorecord = false;                                    
                    }
                    break;
                }
                wait_ms(200);
            
                
            }//eo if kbhit
        }//eo while
        return userSelection;
}