#include "mbed.h"

#include "menuIDs.h"
#include "MainMenu.h"
#include "console.h"

extern BusInOut switches; //(p21, p22, p23, p24)
extern MainMenu pageMenu[MAXPAGES ];
extern volatile bool exittorecord;


int ContrastPageHandler()
{
     int userSelection = 0;
     pageMenu[CONTRAST].printMenu();

    unsigned char lastState = 0x0f;  //0000 1111
     bool exitCurrentMenu = false;

     while ( exitCurrentMenu == false)
        {
        
        unsigned char currentState = switches.read();  //reading a port add a AND MASK & 0b00000111
        wait_ms(10);
        if( currentState == switches.read() && currentState != lastState)
            {
            lastState = currentState; 
            switch(currentState)
                {
                case 0x0e:
                    pageMenu[CONTRAST].erase();
                    printXY("                       ", 5, 10);
                    userSelection = SCREENSET;
                    exitCurrentMenu = true;
                    break;
                case 0x0d:
                     pageMenu[CONTRAST].highlightPrevItem();
                    break;
                case 0x0b:
                     pageMenu[CONTRAST].highlightNextItem();
                    break;
                case 0x07:
                    userSelection = pageMenu[CONTRAST].getHighlightedItem() ;
                    pageMenu[CONTRAST].removeselection();
                    pageMenu[CONTRAST].selection();
                    break;
                }//eo select
  /*              
                if (userSelection != 0 && userSelection != SCREENSET)
                    {
                    // place code here to handle actions processed directly from this page
                    switch(userSelection)
                        {
                        case CONTRASTUP:
                            printXY("Contrast +1          ", 5, 10);
                            //call function to perform task
                            break;
                        case CONTRASTDOWN:
                            printXY("Contrast -1    ",5,10);
                            //call function to perform task
                            break;
                        }
                    // eo place code here ......
                    userSelection = 0;
                    }
*/
                wait_ms(200);
                if (exittorecord == true)
                     break;
                    
           }//eo if kbhit
        }//eo while
        return userSelection;
}