#include "mbed.h"

#include "menuIDs.h"
#include "MainMenu.h"
#include "console.h"

extern BusInOut switches; //(p21, p22, p23, p24)
extern MainMenu pageMenu[MAXPAGES ];
extern volatile bool exittorecord;

int ScreensettingsPageHandler()
{
     int userSelection = 0;
     pageMenu[SCREENSET].printMenu();

     unsigned char lastState = 0x0f;  //0000 1111
     bool exitCurrentMenu = false;

     while ( exitCurrentMenu == false)
        {
        
        unsigned char currentState = switches.read();  //reading a port add a AND MASK & 0b00000111
        wait_ms(10);
        if( currentState == switches.read() && currentState != lastState)
            {
            lastState = currentState; 
            switch(currentState)
                {
                case 0x0e:
                    pageMenu[SCREENSET].erase();
                    userSelection = HOME;
                    exitCurrentMenu = true;
                    break;
                case 0x0d:
                     pageMenu[SCREENSET].highlightPrevItem();
                    break;
                case 0x0b:
                     pageMenu[SCREENSET].highlightNextItem();
                    break;
                case 0x07:
                    pageMenu[SCREENSET].erase();
                    userSelection = pageMenu[SCREENSET].getHighlightedItem() - SCREENSETTINGSOFFSET;
                    exitCurrentMenu = true;
                    break;
                }//eo select
            wait_ms(200);
            if (exittorecord == true)
            break;
            
            }//eo if kbhit
        }//eo while
        return userSelection;
}