#include "mbed.h"

#include "menuIDs.h"
#include "MainMenu.h"
#include "console.h"

extern BusInOut switches; //(p21, p22, p23, p24)
extern MainMenu pageMenu[MAXPAGES ];
extern volatile bool exittorecord;


int AGCPageHandler()
{
     int userSelection = 0;
     pageMenu[AGC].printMenu();

    unsigned char lastState = 0x0f;  //0000 1111
     bool exitCurrentMenu = false;

     while ( exitCurrentMenu == false)
        {
        
        unsigned char currentState = switches.read();  //reading a port add a AND MASK & 0b00000111
        wait_ms(10);
        if( currentState == switches.read() && currentState != lastState)
            {
            lastState = currentState; 
            switch(currentState)
                {
                case 0x0e:
                    pageMenu[AGC].erase();
                    printXY("                       ", 5, 10);
                    userSelection = RECORDSET;
                    exitCurrentMenu = true;
                    break;
                case 0x0d:
                     pageMenu[AGC].highlightPrevItem();
                    break;
                case 0x0b:
                     pageMenu[AGC].highlightNextItem();
                    break;
                case 0x07:
                    userSelection = pageMenu[AGC].getHighlightedItem() ;
                    pageMenu[AGC].removeselection();
                    pageMenu[AGC].selection();
                    break;
                }//eo select
/*                
                if (userSelection != 0 && userSelection != RECORDSET)
                    {
                    // place code here to handle actions processed directly from this page
                    switch(userSelection)
                        {
                        case AGCON:
                            printXY(" ",  5,2);
                            printXY("<", 4, 1);
                            //call function to perform task
                            break;
                        case AGCOFF:
                            printXY(" ", 4, 1);
                            printXY("<",5, 2);
                            //call function to perform task
                            break;
                        }
                    // eo place code here ......
                    userSelection = 0;
                    }
*/
                wait_ms(200);
        if (exittorecord == true) 
            break;
            
        
            }//eo if kbhit
        }//eo while
        return userSelection;
}