#include "mbed.h"

#include "menuIDs.h"
#include "MainMenu.h"
#include "console.h"

extern BusInOut switches; //(p21, p22, p23, p24)
extern MainMenu pageMenu[MAXPAGES ];


int WarningscreenPageHandler()
{
     int userSelection = 0;
     pageMenu[WARNINGSCR].printMenu();

     unsigned char lastState = 0x0f;  //0000 1111
     bool exitCurrentMenu = false;

     while ( exitCurrentMenu == false)
        {
        
        unsigned char currentState = switches.read();  //reading a port add a AND MASK & 0b00000111
        wait_ms(10);
        if( currentState == switches.read() && currentState != lastState)
            {
            lastState = currentState; 
            switch(currentState)
                {
                case 0x0e:
                    pageMenu[WARNINGSCR].erase();
                    printXY("                       ", 5, 10);    //erases the ACTION prompt
                    userSelection = DELETESCR;
                    exitCurrentMenu = true;
                    break;
                case 0x0d:
                     pageMenu[WARNINGSCR].highlightPrevItem();
                    break;
                case 0x0b:
                     pageMenu[WARNINGSCR].highlightNextItem();
                    break;
                case 0x07:
                    userSelection = pageMenu[WARNINGSCR].getHighlightedItem() ;
                    break;
                }//eo select

                // is the user selection an ACTION  assigned to this page
                if (userSelection != 0 && userSelection > WARNINGSCROFFSET)  //page selections are 0 through 12
                    {
                    // place code here to handle actions processed directly from this page
                    switch(userSelection)
                        {
                        case DELETENO:
                            pageMenu[WARNINGSCR].erase();
                            printXY("                       ", 5, 10);    //erases the ACTION prompt
                            userSelection = DELETESCR;
                            exitCurrentMenu = true;
                            break;
                        case DELETEYES:
                            printXY("Track Deleted    ",5,10);
                            //call function to perform task
                            break;
                        }
                    // eo place code here ......
                    userSelection = 0;
                    }
                wait_ms(200);
            }//eo if kbhit
        }//eo while
        return userSelection;
}